/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Serializable,
Cloneable {
    private static final int DEFAULT_CAPACITY = 21;
    static final Object nullslot = new Object();
    private static final long serialVersionUID = 8188218128353913216L;
    int size;
    transient Object[] table;
    transient int modCount;
    private transient Set<Map.Entry<K, V>> entries;
    private transient int threshold;

    public IdentityHashMap() {
        this(21);
    }

    public IdentityHashMap(int max) {
        if (max < 0) {
            throw new IllegalArgumentException();
        }
        if (max < 2) {
            max = 2;
        }
        this.table = new Object[max << 1];
        this.threshold = (max >> 2) * 3;
    }

    public IdentityHashMap(Map<? extends K, ? extends V> m) {
        this(Math.max(m.size() << 1, 21));
        this.putAll(m);
    }

    @Override
    public void clear() {
        if (this.size != 0) {
            ++this.modCount;
            Arrays.fill(this.table, null);
            this.size = 0;
        }
    }

    @Override
    public Object clone() {
        try {
            IdentityHashMap copy = (IdentityHashMap)super.clone();
            copy.table = (Object[])this.table.clone();
            copy.entries = null;
            return copy;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return (key = this.xform(key)) == this.table[this.hash(key)];
    }

    @Override
    public boolean containsValue(Object value) {
        value = this.xform(value);
        int i = this.table.length - 1;
        while (i > 0) {
            if (this.table[i] == value) {
                return true;
            }
            i -= 2;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public int size() {
                    return IdentityHashMap.this.size;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new IdentityIterator(2);
                }

                @Override
                public void clear() {
                    IdentityHashMap.this.clear();
                }

                @Override
                public boolean contains(Object o) {
                    Object key;
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry m = (Map.Entry)o;
                    Object value = IdentityHashMap.this.xform(m.getValue());
                    return value == IdentityHashMap.this.table[IdentityHashMap.this.hash(key = IdentityHashMap.this.xform(m.getKey())) + 1];
                }

                @Override
                public int hashCode() {
                    return IdentityHashMap.this.hashCode();
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Object key = IdentityHashMap.this.xform(((Map.Entry)o).getKey());
                    int h = IdentityHashMap.this.hash(key);
                    if (IdentityHashMap.this.table[h] == key) {
                        --IdentityHashMap.this.size;
                        ++IdentityHashMap.this.modCount;
                        IdentityHashMap.this.removeAtIndex(h);
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.entries;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public V get(Object key) {
        int h = this.hash(key = this.xform(key));
        return (V)(this.table[h] == key ? this.unxform(this.table[h + 1]) : null);
    }

    @Override
    public int hashCode() {
        int hash = 0;
        int i = this.table.length - 2;
        while (i >= 0) {
            Object key = this.table[i];
            if (key != null) {
                hash += System.identityHashCode(this.unxform(key)) ^ System.identityHashCode(this.unxform(this.table[i + 1]));
            }
            i -= 2;
        }
        return hash;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Set<K> keySet() {
        if (this.keys == null) {
            this.keys = new AbstractSet<K>(){

                @Override
                public int size() {
                    return IdentityHashMap.this.size;
                }

                @Override
                public Iterator<K> iterator() {
                    return new IdentityIterator(0);
                }

                @Override
                public void clear() {
                    IdentityHashMap.this.clear();
                }

                @Override
                public boolean contains(Object o) {
                    return IdentityHashMap.this.containsKey(o);
                }

                @Override
                public int hashCode() {
                    int hash = 0;
                    int i = IdentityHashMap.this.table.length - 2;
                    while (i >= 0) {
                        Object key = IdentityHashMap.this.table[i];
                        if (key != null) {
                            hash += System.identityHashCode(IdentityHashMap.this.unxform(key));
                        }
                        i -= 2;
                    }
                    return hash;
                }

                @Override
                public boolean remove(Object o) {
                    int h = IdentityHashMap.this.hash(o = IdentityHashMap.this.xform(o));
                    if (IdentityHashMap.this.table[h] == o) {
                        --IdentityHashMap.this.size;
                        ++IdentityHashMap.this.modCount;
                        IdentityHashMap.this.removeAtIndex(h);
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.keys;
    }

    @Override
    public V put(K key, V value) {
        key = this.xform(key);
        value = this.xform(value);
        int h = this.hash(key);
        if (this.table[h] == key) {
            Object r = this.unxform(this.table[h + 1]);
            this.table[h + 1] = value;
            return (V)r;
        }
        if (this.size > this.threshold) {
            Object[] old = this.table;
            this.table = new Object[old.length * 2 + 2];
            this.size = 0;
            this.threshold = (this.table.length >>> 3) * 3;
            int i = old.length - 2;
            while (i >= 0) {
                Object oldkey = old[i];
                if (oldkey != null) {
                    h = this.hash(oldkey);
                    this.table[h] = oldkey;
                    this.table[h + 1] = old[i + 1];
                    ++this.size;
                }
                i -= 2;
            }
            h = this.hash(key);
        }
        ++this.modCount;
        ++this.size;
        this.table[h] = key;
        this.table[h + 1] = value;
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        super.putAll(m);
    }

    final void removeAtIndex(int i) {
        while (true) {
            Object key;
            int r;
            this.table[i] = null;
            this.table[i + 1] = null;
            int j = i;
            do {
                if ((i -= 2) < 0) {
                    i = this.table.length - 2;
                }
                if ((key = this.table[i]) != null) continue;
                return;
            } while (i <= (r = Math.abs(System.identityHashCode(key) % (this.table.length >> 1)) << 1) && r < j || r < j && j < i || j < i && i <= r);
            this.table[j] = this.table[i];
            this.table[j + 1] = this.table[i + 1];
        }
    }

    @Override
    public V remove(Object key) {
        int h = this.hash(key = this.xform(key));
        if (this.table[h] == key) {
            ++this.modCount;
            --this.size;
            Object r = this.unxform(this.table[h + 1]);
            this.removeAtIndex(h);
            return (V)r;
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public int size() {
                    return IdentityHashMap.this.size;
                }

                @Override
                public Iterator<V> iterator() {
                    return new IdentityIterator(1);
                }

                @Override
                public void clear() {
                    IdentityHashMap.this.clear();
                }

                @Override
                public boolean remove(Object o) {
                    o = IdentityHashMap.this.xform(o);
                    int i = IdentityHashMap.this.table.length - 1;
                    while (i > 0) {
                        if (IdentityHashMap.this.table[i] == o) {
                            ++IdentityHashMap.this.modCount;
                            --IdentityHashMap.this.size;
                            IdentityHashMap.this.removeAtIndex(i - 1);
                            return true;
                        }
                        i -= 2;
                    }
                    return false;
                }
            };
        }
        return this.values;
    }

    final Object xform(Object o) {
        if (o == null) {
            o = nullslot;
        }
        return o;
    }

    final Object unxform(Object o) {
        if (o == nullslot) {
            o = null;
        }
        return o;
    }

    final int hash(Object key) {
        int h = Math.abs(System.identityHashCode(key) % (this.table.length >> 1)) << 1;
        while (this.table[h] != key && this.table[h] != null) {
            if ((h -= 2) >= 0) continue;
            h = this.table.length - 2;
        }
        return h;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int num = s.readInt();
        this.table = new Object[Math.max(num << 1, 21) << 1];
        while (--num >= 0) {
            this.put(s.readObject(), s.readObject());
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        int i = this.table.length - 2;
        while (i >= 0) {
            Object key = this.table[i];
            if (key != null) {
                s.writeObject(this.unxform(key));
                s.writeObject(this.unxform(this.table[i + 1]));
            }
            i -= 2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class IdentityEntry<EK, EV>
    implements Map.Entry<EK, EV> {
        final int loc;
        final int knownMod;

        IdentityEntry(int loc) {
            this.knownMod = IdentityHashMap.this.modCount;
            this.loc = loc;
        }

        @Override
        public boolean equals(Object o) {
            if (this.knownMod != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return IdentityHashMap.this.table[this.loc] == IdentityHashMap.this.xform(e.getKey()) && IdentityHashMap.this.table[this.loc + 1] == IdentityHashMap.this.xform(e.getValue());
        }

        @Override
        public EK getKey() {
            if (this.knownMod != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return (EK)IdentityHashMap.this.unxform(IdentityHashMap.this.table[this.loc]);
        }

        @Override
        public EV getValue() {
            if (this.knownMod != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return (EV)IdentityHashMap.this.unxform(IdentityHashMap.this.table[this.loc + 1]);
        }

        @Override
        public int hashCode() {
            if (this.knownMod != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return System.identityHashCode(IdentityHashMap.this.unxform(IdentityHashMap.this.table[this.loc])) ^ System.identityHashCode(IdentityHashMap.this.unxform(IdentityHashMap.this.table[this.loc + 1]));
        }

        @Override
        public EV setValue(EV value) {
            if (this.knownMod != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            Object r = IdentityHashMap.this.unxform(IdentityHashMap.this.table[this.loc + 1]);
            IdentityHashMap.this.table[this.loc + 1] = IdentityHashMap.this.xform(value);
            return (EV)r;
        }

        public String toString() {
            if (this.knownMod != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return IdentityHashMap.this.unxform(IdentityHashMap.this.table[this.loc]) + "=" + IdentityHashMap.this.unxform(IdentityHashMap.this.table[this.loc + 1]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IdentityIterator<I>
    implements Iterator<I> {
        final int type;
        int knownMod;
        int count;
        int loc;

        IdentityIterator(int type) {
            this.knownMod = IdentityHashMap.this.modCount;
            this.count = IdentityHashMap.this.size;
            this.loc = IdentityHashMap.this.table.length;
            this.type = type;
        }

        @Override
        public boolean hasNext() {
            return this.count > 0;
        }

        @Override
        public I next() {
            Object key;
            if (this.knownMod != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.count == 0) {
                throw new NoSuchElementException();
            }
            --this.count;
            do {
                this.loc -= 2;
            } while ((key = IdentityHashMap.this.table[this.loc]) == null);
            return (I)(this.type == 0 ? IdentityHashMap.this.unxform(key) : (this.type == 1 ? IdentityHashMap.this.unxform(IdentityHashMap.this.table[this.loc + 1]) : new IdentityEntry(this.loc)));
        }

        @Override
        public void remove() {
            if (this.knownMod != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.loc == IdentityHashMap.this.table.length) {
                throw new IllegalStateException();
            }
            ++IdentityHashMap.this.modCount;
            --IdentityHashMap.this.size;
            IdentityHashMap.this.removeAtIndex(this.loc);
            ++this.knownMod;
        }
    }
}

