/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.javah;

import gnu.classpath.tools.javah.ClassWrapper;
import gnu.classpath.tools.javah.Main;
import java.io.IOException;
import org.objectweb.asm.Type;

public class JniHelper {
    public static String getName(Main classpath, Type type) throws IOException {
        if (type == Type.BOOLEAN_TYPE) {
            return "jboolean";
        }
        if (type == Type.BYTE_TYPE) {
            return "jbyte";
        }
        if (type == Type.CHAR_TYPE) {
            return "jchar";
        }
        if (type == Type.SHORT_TYPE) {
            return "jshort";
        }
        if (type == Type.INT_TYPE) {
            return "jint";
        }
        if (type == Type.LONG_TYPE) {
            return "jlong";
        }
        if (type == Type.FLOAT_TYPE) {
            return "jfloat";
        }
        if (type == Type.DOUBLE_TYPE) {
            return "jdouble";
        }
        if (type == Type.VOID_TYPE) {
            return "void";
        }
        if (type.getSort() == 9) {
            Type elt = type.getElementType();
            int eltSort = elt.getSort();
            if (type.getDimensions() == 1 && eltSort != 10) {
                return String.valueOf(JniHelper.getName(classpath, elt)) + "Array";
            }
            return "jobjectArray";
        }
        String className = type.getClassName();
        if (className.equals("java/lang/Class") || className.equals("java.lang.Class")) {
            return "jclass";
        }
        if (className.equals("java/lang/String") || className.equals("java.lang.String")) {
            return "jstring";
        }
        ClassWrapper klass = classpath.getClass(className);
        if (klass.isThrowable()) {
            return "jthrowable";
        }
        return "jobject";
    }

    public static String mangle(String name) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c == '_') {
                result.append("_1");
            } else if (c == ';') {
                result.append("_2");
            } else if (c == '[') {
                result.append("_3");
            } else if (c == '/') {
                result.append("_");
            } else if (c == '$') {
                result.append("_");
            } else if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                result.append(c);
            } else {
                result.append("_0");
                String hex = "0000" + Integer.toHexString(c);
                result.append(hex.substring(hex.length() - 4));
            }
            ++i;
        }
        return result.toString();
    }
}

