/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.dgc;

import gnu.java.rmi.server.UnicastRef;
import java.lang.ref.WeakReference;
import java.rmi.dgc.Lease;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;

public class LeaseRenewingTask {
    public static long REQUEST_LEASE_DURATION = 60000L;
    LinkedList ref = new LinkedList();
    Lease lease = new Lease(null, REQUEST_LEASE_DURATION);
    static Timer timer = new Timer(true);
    static WeakHashMap existingTasks = new WeakHashMap();

    public LeaseRenewingTask(UnicastRef renewIt) {
        this.lease = this.notifyDGC(renewIt);
        if (this.lease != null) {
            this.schedule(this.lease);
            this.ref.add(new WeakReference<UnicastRef>(renewIt));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleLeases(UnicastRef renewIt) {
        if (renewIt == null) {
            return;
        }
        try {
            WeakHashMap weakHashMap = existingTasks;
            synchronized (weakHashMap) {
                LeaseRenewingTask task = (LeaseRenewingTask)existingTasks.get(renewIt);
                if (task != null) {
                    LinkedList linkedList = task.ref;
                    synchronized (linkedList) {
                        task.ref.add(new WeakReference<UnicastRef>(renewIt));
                    }
                } else {
                    existingTasks.put(renewIt, new LeaseRenewingTask(renewIt));
                }
            }
        }
        catch (Exception ex) {
            InternalError ierr = new InternalError("Lease for " + renewIt);
            ierr.initCause(ex);
            throw ierr;
        }
    }

    public void schedule(Lease lease) {
        long value = lease.getValue();
        long reduced = value * 90L / 100L;
        if (reduced == 0L) {
            reduced = value;
        }
        timer.schedule((TimerTask)new LeaseTimerTask(), reduced);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renew() {
        Lease lease;
        Object renewIt = null;
        LinkedList linkedList = this.ref;
        synchronized (linkedList) {
            Iterator iter = this.ref.iterator();
            while (iter.hasNext() && renewIt == null) {
                WeakReference w = (WeakReference)iter.next();
                renewIt = w.get();
                if (renewIt != null) continue;
                iter.remove();
            }
        }
        if (renewIt != null && (lease = this.notifyDGC(renewIt)) != null) {
            this.schedule(lease);
        }
    }

    public Lease notifyDGC(UnicastRef renewIt) {
        try {
            return renewIt.notifyDGC(this.lease);
        }
        catch (Exception exception) {
            return null;
        }
    }

    class LeaseTimerTask
    extends TimerTask {
        LeaseTimerTask() {
        }

        public void run() {
            LeaseRenewingTask.this.renew();
        }
    }
}

