/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetEvent;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropTargetDragEvent
extends DropTargetEvent {
    private static final long serialVersionUID = -8422265619058953682L;
    private final int dropAction;
    private final int srcActions;
    private final Point location;

    public DropTargetDragEvent(DropTargetContext context, Point location, int dropAction, int srcActions) {
        super(context);
        if (location == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new IllegalArgumentException();
        }
        if (dropAction != 0 && dropAction != 1 && dropAction != 2 && dropAction != 3 && dropAction != 0x40000000 && dropAction != 0x40000000) {
            throw new IllegalArgumentException();
        }
        int srcActionsMask = 0x40000003;
        if (~(srcActions ^ srcActionsMask) != 0) {
            throw new IllegalArgumentException();
        }
        this.dropAction = dropAction;
        this.srcActions = srcActions;
        this.location = location;
    }

    public void acceptDrag(int dragOperation) {
        this.context.acceptDrag(dragOperation);
    }

    public DataFlavor[] getCurrentDataFlavors() {
        return this.context.getCurrentDataFlavors();
    }

    public List<DataFlavor> getCurrentDataFlavorsAsList() {
        return this.context.getCurrentDataFlavorsAsList();
    }

    public int getDropAction() {
        return this.dropAction & ((DropTargetContext)this.source).getTargetActions();
    }

    public Point getLocation() {
        return this.location;
    }

    public int getSourceActions() {
        return this.srcActions;
    }

    public boolean isDataFlavorSupported(DataFlavor df) {
        return this.context.isDataFlavorSupported(df);
    }

    public void rejectDrag() {
        this.context.rejectDrag();
    }

    public Transferable getTransferable() {
        return this.context.getTransferable();
    }
}

