/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Polygon;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComponentInputMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.OptionPaneUI;
import javax.swing.plaf.basic.SharedUIDefaults;

public class BasicOptionPaneUI
extends OptionPaneUI {
    public static final int MinimumWidth = 262;
    public static final int MinimumHeight = 90;
    protected boolean hasCustomComponents;
    protected Component initialFocusComponent;
    protected JComponent inputComponent;
    protected Dimension minimumSize;
    protected PropertyChangeListener propertyChangeListener;
    protected JOptionPane optionPane;
    private static final int ICON_SIZE = 36;
    private static final String OK_STRING = "OK";
    private static final String YES_STRING = "Yes";
    private static final String NO_STRING = "No";
    private static final String CANCEL_STRING = "Cancel";
    transient Container messageAreaContainer;
    transient Container buttonContainer;
    private static MessageIcon errorIcon = new MessageIcon(){

        public void paintIcon(Component c, Graphics g, int x, int y) {
            int[] nArray = new int[8];
            nArray[2] = 9;
            nArray[3] = 27;
            nArray[4] = 36;
            nArray[5] = 36;
            nArray[6] = 27;
            nArray[7] = 9;
            int[] nArray2 = new int[8];
            nArray2[0] = 9;
            nArray2[1] = 27;
            nArray2[2] = 36;
            nArray2[3] = 36;
            nArray2[4] = 27;
            nArray2[5] = 9;
            Polygon oct = new Polygon(nArray, nArray2, 8);
            g.translate(x, y);
            Color saved = g.getColor();
            g.setColor(Color.RED);
            g.fillPolygon(oct);
            g.setColor(Color.BLACK);
            g.drawRect(13, 16, 10, 4);
            g.setColor(saved);
            g.translate(-x, -y);
        }
    };
    private static MessageIcon infoIcon = new MessageIcon(){

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            Color saved = g.getColor();
            g.setColor(Color.RED);
            g.fillOval(0, 0, 36, 36);
            g.setColor(Color.BLACK);
            g.drawOval(16, 6, 4, 4);
            Polygon bottomI = new Polygon(new int[]{15, 15, 13, 13, 23, 23, 21, 21}, new int[]{12, 28, 28, 30, 30, 28, 28, 12}, 8);
            g.drawPolygon(bottomI);
            g.setColor(saved);
            g.translate(-x, -y);
        }
    };
    private static MessageIcon warningIcon = new MessageIcon(){

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            Color saved = g.getColor();
            g.setColor(Color.YELLOW);
            int[] nArray = new int[3];
            nArray[1] = 18;
            nArray[2] = 36;
            int[] nArray2 = new int[3];
            nArray2[0] = 36;
            nArray2[2] = 36;
            Polygon triangle = new Polygon(nArray, nArray2, 3);
            g.fillPolygon(triangle);
            g.setColor(Color.BLACK);
            Polygon excl = new Polygon(new int[]{15, 16, 20, 21}, new int[]{8, 26, 26, 8}, 4);
            g.drawPolygon(excl);
            g.drawOval(16, 30, 4, 4);
            g.setColor(saved);
            g.translate(-x, -y);
        }
    };
    private static MessageIcon questionIcon = new MessageIcon(){

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            Color saved = g.getColor();
            g.setColor(Color.GREEN);
            g.fillRect(0, 0, 36, 36);
            g.setColor(Color.BLACK);
            g.drawOval(11, 2, 16, 16);
            g.drawOval(14, 5, 10, 10);
            g.setColor(Color.GREEN);
            g.fillRect(0, 10, 36, 26);
            g.setColor(Color.BLACK);
            g.drawLine(11, 10, 14, 10);
            g.drawLine(24, 10, 17, 22);
            g.drawLine(27, 10, 20, 22);
            g.drawLine(17, 22, 20, 22);
            g.drawOval(17, 25, 3, 3);
            g.setColor(saved);
            g.translate(-x, -y);
        }
    };

    protected void addButtonComponents(Container container, Object[] buttons, int initialIndex) {
        if (buttons == null) {
            return;
        }
        int i = 0;
        while (i < buttons.length) {
            if (buttons[i] != null) {
                Component toAdd;
                if (buttons[i] instanceof Component) {
                    toAdd = (Component)buttons[i];
                } else {
                    toAdd = buttons[i] instanceof Icon ? new JButton((Icon)buttons[i]) : new JButton(buttons[i].toString());
                    this.hasCustomComponents = true;
                }
                if (toAdd instanceof JButton) {
                    ((JButton)toAdd).addActionListener(this.createButtonActionListener(i));
                }
                if (i == initialIndex) {
                    this.initialFocusComponent = toAdd;
                }
                container.add(toAdd);
            }
            ++i;
        }
        this.selectInitialValue(this.optionPane);
    }

    protected void addIcon(Container top) {
        JLabel iconLabel = null;
        Icon icon = this.getIcon();
        if (icon != null) {
            iconLabel = new JLabel(icon);
            this.configureLabel(iconLabel);
            top.add((Component)iconLabel, "West");
        }
    }

    private static GridBagConstraints createConstraints() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.anchor = 21;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 3, 0);
        return constraints;
    }

    protected void addMessageComponents(Container container, GridBagConstraints cons, Object msg, int maxll, boolean internallyCreated) {
        if (msg == null) {
            return;
        }
        this.hasCustomComponents = internallyCreated;
        if (msg instanceof Object[]) {
            Object[] arr = (Object[])msg;
            int i = 0;
            while (i < arr.length) {
                this.addMessageComponents(container, cons, arr[i], maxll, internallyCreated);
                ++i;
            }
            return;
        }
        if (msg instanceof Component) {
            container.add((Component)msg, cons);
            ++cons.gridy;
        } else if (msg instanceof Icon) {
            JLabel label = new JLabel((Icon)msg);
            this.configureLabel(label);
            container.add((Component)label, cons);
            ++cons.gridy;
        } else if (msg.toString().length() > maxll || msg.toString().contains("\n")) {
            Box tmp = new Box(1);
            this.burstStringInto(tmp, msg.toString(), maxll);
            this.addMessageComponents(container, cons, tmp, maxll, true);
        } else {
            JLabel label = new JLabel(msg.toString());
            this.configureLabel(label);
            this.addMessageComponents(container, cons, label, maxll, true);
        }
    }

    protected void burstStringInto(Container c, String d, int maxll) {
        String remainder;
        String line;
        if (d == null || c == null) {
            return;
        }
        int newlineIndex = d.indexOf(10);
        if (newlineIndex >= 0 && newlineIndex < maxll) {
            line = d.substring(0, newlineIndex);
            remainder = d.substring(newlineIndex + 1);
        } else {
            line = d.substring(0, maxll);
            remainder = d.substring(maxll);
        }
        JLabel label = new JLabel(line);
        this.configureLabel(label);
        c.add(label);
        if (remainder.length() == 0) {
            return;
        }
        if (remainder.length() > maxll || remainder.contains("\n")) {
            this.burstStringInto(c, remainder, maxll);
        } else {
            JLabel l = new JLabel(remainder);
            this.configureLabel(l);
            c.add(l);
        }
    }

    public boolean containsCustomComponents(JOptionPane op) {
        return this.hasCustomComponents;
    }

    protected ActionListener createButtonActionListener(int buttonIndex) {
        return new ButtonActionListener(buttonIndex);
    }

    protected Container createButtonArea() {
        JPanel buttonPanel = new JPanel();
        Border b = UIManager.getBorder("OptionPane.buttonAreaBorder");
        if (b != null) {
            buttonPanel.setBorder(b);
        }
        buttonPanel.setLayout(this.createLayoutManager());
        this.addButtonComponents(buttonPanel, this.getButtons(), this.getInitialValueIndex());
        return buttonPanel;
    }

    protected LayoutManager createLayoutManager() {
        return new ButtonAreaLayout(this.getSizeButtonsToSameWidth(), 6);
    }

    protected Container createMessageArea() {
        JPanel messageArea = new JPanel();
        Border messageBorder = UIManager.getBorder("OptionPane.messageAreaBorder");
        if (messageBorder != null) {
            messageArea.setBorder(messageBorder);
        }
        messageArea.setLayout(new BorderLayout());
        this.addIcon(messageArea);
        JPanel rightSide = new JPanel();
        rightSide.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        rightSide.setLayout(new GridBagLayout());
        GridBagConstraints con = BasicOptionPaneUI.createConstraints();
        this.addMessageComponents(rightSide, con, this.getMessage(), this.getMaxCharactersPerLineCount(), false);
        if (this.optionPane.getWantsInput()) {
            Object[] selection = this.optionPane.getSelectionValues();
            this.inputComponent = selection == null ? new JTextField(15) : (selection.length < 20 ? new JComboBox(selection) : new JList(selection));
            if (this.inputComponent != null) {
                this.addMessageComponents(rightSide, con, this.inputComponent, this.getMaxCharactersPerLineCount(), false);
                this.resetSelectedValue();
                this.selectInitialValue(this.optionPane);
            }
        }
        messageArea.add((Component)rightSide, "Center");
        return messageArea;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected Container createSeparator() {
        return null;
    }

    public static ComponentUI createUI(JComponent x) {
        return new BasicOptionPaneUI();
    }

    protected Object[] getButtons() {
        if (this.optionPane.getOptions() != null) {
            return this.optionPane.getOptions();
        }
        switch (this.optionPane.getOptionType()) {
            case 0: {
                return new Object[]{YES_STRING, NO_STRING};
            }
            case 1: {
                return new Object[]{YES_STRING, NO_STRING, CANCEL_STRING};
            }
            case 2: {
                return new Object[]{OK_STRING, CANCEL_STRING};
            }
            case -1: {
                Object[] objectArray;
                if (this.optionPane.getWantsInput()) {
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = OK_STRING;
                    objectArray = objectArray2;
                    objectArray2[1] = CANCEL_STRING;
                } else if (this.optionPane.getMessageType() == 3) {
                    Object[] objectArray3 = new Object[3];
                    objectArray3[0] = YES_STRING;
                    objectArray3[1] = NO_STRING;
                    objectArray = objectArray3;
                    objectArray3[2] = CANCEL_STRING;
                } else {
                    Object[] objectArray4 = new Object[1];
                    objectArray = objectArray4;
                    objectArray4[0] = OK_STRING;
                }
                return objectArray;
            }
        }
        return null;
    }

    protected Icon getIcon() {
        if (this.optionPane.getIcon() != null) {
            return this.optionPane.getIcon();
        }
        return this.getIconForType(this.optionPane.getMessageType());
    }

    protected Icon getIconForType(int messageType) {
        MessageIcon tmp = null;
        switch (messageType) {
            case 0: {
                tmp = errorIcon;
                break;
            }
            case 1: {
                tmp = infoIcon;
                break;
            }
            case 2: {
                tmp = warningIcon;
                break;
            }
            case 3: {
                tmp = questionIcon;
            }
        }
        return tmp;
    }

    protected int getInitialValueIndex() {
        Object[] buttons = this.getButtons();
        if (buttons == null) {
            return -1;
        }
        Object select = this.optionPane.getInitialValue();
        int i = 0;
        while (i < buttons.length) {
            if (select == buttons[i]) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    protected int getMaxCharactersPerLineCount() {
        return this.optionPane.getMaxCharactersPerLineCount();
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    protected Object getMessage() {
        return this.optionPane.getMessage();
    }

    public Dimension getMinimumOptionPaneSize() {
        return this.minimumSize;
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension d = this.optionPane.getLayout().preferredLayoutSize(this.optionPane);
        Dimension d2 = this.getMinimumOptionPaneSize();
        int w = Math.max(d.width, d2.width);
        int h = Math.max(d.height, d2.height);
        return new Dimension(w, h);
    }

    protected boolean getSizeButtonsToSameWidth() {
        return true;
    }

    protected void installComponents() {
        this.optionPane.add(this.createMessageArea());
        Container sep = this.createSeparator();
        if (sep != null) {
            this.optionPane.add(sep);
        }
        this.optionPane.add(this.createButtonArea());
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.optionPane, "OptionPane.background", "OptionPane.foreground", "OptionPane.font");
        LookAndFeel.installBorder(this.optionPane, "OptionPane.border");
        this.optionPane.setOpaque(true);
        this.minimumSize = UIManager.getDimension("OptionPane.minimumSize");
    }

    protected void installKeyboardActions() {
        Object[] bindings = (Object[])SharedUIDefaults.get("OptionPane.windowBindings");
        ComponentInputMap inputMap = LookAndFeel.makeComponentInputMap(this.optionPane, bindings);
        SwingUtilities.replaceUIInputMap(this.optionPane, 2, inputMap);
        SwingUtilities.replaceUIActionMap(this.optionPane, this.getActionMap());
    }

    private ActionMap getActionMap() {
        ActionMap am = (ActionMap)UIManager.get("OptionPane.actionMap");
        if (am == null) {
            am = this.createDefaultActions();
            UIManager.getLookAndFeelDefaults().put("OptionPane.actionMap", am);
        }
        return am;
    }

    private ActionMap createDefaultActions() {
        ActionMapUIResource am = new ActionMapUIResource();
        OptionPaneCloseAction action = new OptionPaneCloseAction();
        am.put("close", action);
        return am;
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.optionPane.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void installUI(JComponent c) {
        if (c instanceof JOptionPane) {
            this.optionPane = (JOptionPane)c;
            this.installDefaults();
            this.installComponents();
            this.installListeners();
            this.installKeyboardActions();
        }
    }

    protected void resetInputValue() {
        if (this.optionPane.getWantsInput() && this.inputComponent != null) {
            Object output = null;
            if (this.inputComponent instanceof JTextField) {
                output = ((JTextField)this.inputComponent).getText();
            } else if (this.inputComponent instanceof JComboBox) {
                output = ((JComboBox)this.inputComponent).getSelectedItem();
            } else if (this.inputComponent instanceof JList) {
                output = ((JList)this.inputComponent).getSelectedValue();
            }
            if (output != null) {
                this.optionPane.setInputValue(output);
            }
        }
    }

    public void selectInitialValue(JOptionPane op) {
        if (this.inputComponent != null) {
            this.inputComponent.requestFocus();
            return;
        }
        if (this.initialFocusComponent != null) {
            this.initialFocusComponent.requestFocus();
        }
    }

    void resetSelectedValue() {
        if (this.inputComponent != null) {
            Object init = this.optionPane.getInitialSelectionValue();
            if (init == null) {
                return;
            }
            if (this.inputComponent instanceof JTextField) {
                ((JTextField)this.inputComponent).setText((String)init);
            } else if (this.inputComponent instanceof JComboBox) {
                ((JComboBox)this.inputComponent).setSelectedItem(init);
            } else {
                boolean cfr_ignored_0 = this.inputComponent instanceof JList;
            }
        }
    }

    protected void uninstallComponents() {
        this.optionPane.removeAll();
        this.buttonContainer = null;
        this.messageAreaContainer = null;
    }

    protected void uninstallDefaults() {
        this.optionPane.setFont(null);
        this.optionPane.setForeground(null);
        this.optionPane.setBackground(null);
        this.minimumSize = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.optionPane, 1, null);
        SwingUtilities.replaceUIActionMap(this.optionPane, null);
    }

    protected void uninstallListeners() {
        this.optionPane.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.optionPane = null;
    }

    private void configureLabel(JLabel l) {
        Font f;
        Color c = UIManager.getColor("OptionPane.messageForeground");
        if (c != null) {
            l.setForeground(c);
        }
        if ((f = UIManager.getFont("OptionPane.messageFont")) != null) {
            l.setFont(f);
        }
    }

    public class ButtonActionListener
    implements ActionListener {
        protected int buttonIndex;

        public ButtonActionListener(int buttonIndex) {
            this.buttonIndex = buttonIndex;
        }

        public void actionPerformed(ActionEvent e) {
            JInternalFrame inf;
            Integer value = new Integer(-1);
            Object[] options = BasicOptionPaneUI.this.optionPane.getOptions();
            if (options != null) {
                value = new Integer(this.buttonIndex);
            } else {
                String text = ((JButton)e.getSource()).getText();
                if (text.equals(BasicOptionPaneUI.OK_STRING)) {
                    value = new Integer(0);
                }
                if (text.equals(BasicOptionPaneUI.CANCEL_STRING)) {
                    value = new Integer(2);
                }
                if (text.equals(BasicOptionPaneUI.YES_STRING)) {
                    value = new Integer(0);
                }
                if (text.equals(BasicOptionPaneUI.NO_STRING)) {
                    value = new Integer(1);
                }
            }
            BasicOptionPaneUI.this.optionPane.setValue(value);
            BasicOptionPaneUI.this.resetInputValue();
            Window owner = SwingUtilities.windowForComponent(BasicOptionPaneUI.this.optionPane);
            if (owner instanceof JDialog) {
                ((JDialog)owner).dispose();
            }
            if ((inf = (JInternalFrame)SwingUtilities.getAncestorOfClass(JInternalFrame.class, BasicOptionPaneUI.this.optionPane)) != null) {
                try {
                    inf.setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        }
    }

    public static class ButtonAreaLayout
    implements LayoutManager {
        protected boolean centersChildren = true;
        protected int padding;
        protected boolean syncAllWidths;
        private transient int widthOfWidestButton;
        private transient int tallestButton;

        public ButtonAreaLayout(boolean syncAllWidths, int padding) {
            this.syncAllWidths = syncAllWidths;
            this.padding = padding;
        }

        public void addLayoutComponent(String string, Component comp) {
        }

        public boolean getCentersChildren() {
            return this.centersChildren;
        }

        public int getPadding() {
            return this.padding;
        }

        public boolean getSyncAllWidths() {
            return this.syncAllWidths;
        }

        public void layoutContainer(Container container) {
            Component[] buttonList = container.getComponents();
            int x = container.getInsets().left;
            if (this.getCentersChildren()) {
                x += (int)((double)container.getSize().width / 2.0 - (double)this.buttonRowLength(container) / 2.0);
            }
            int i = 0;
            while (i < buttonList.length) {
                Dimension dims = buttonList[i].getPreferredSize();
                if (this.syncAllWidths) {
                    buttonList[i].setBounds(x, 0, this.widthOfWidestButton, dims.height);
                    x += this.widthOfWidestButton + this.getPadding();
                } else {
                    buttonList[i].setBounds(x, 0, dims.width, dims.height);
                    x += dims.width + this.getPadding();
                }
                ++i;
            }
        }

        private int buttonRowLength(Container c) {
            Component[] buttonList = c.getComponents();
            int buttonLength = 0;
            int widest = 0;
            int tallest = 0;
            int i = 0;
            while (i < buttonList.length) {
                Dimension dims = buttonList[i].getPreferredSize();
                buttonLength += dims.width + this.getPadding();
                widest = Math.max(widest, dims.width);
                tallest = Math.max(tallest, dims.height);
                ++i;
            }
            this.widthOfWidestButton = widest;
            this.tallestButton = tallest;
            int width = this.getSyncAllWidths() ? widest * buttonList.length + this.getPadding() * (buttonList.length - 1) : buttonLength;
            Insets insets = c.getInsets();
            return width += insets.left + insets.right;
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public Dimension preferredLayoutSize(Container c) {
            int w = this.buttonRowLength(c);
            return new Dimension(w, this.tallestButton);
        }

        public void removeLayoutComponent(Component c) {
        }

        public void setCentersChildren(boolean newValue) {
            this.centersChildren = newValue;
        }

        public void setPadding(int newPadding) {
            this.padding = newPadding;
        }

        public void setSyncAllWidths(boolean newValue) {
            this.syncAllWidths = newValue;
        }
    }

    private static class MessageIcon
    implements Icon {
        private MessageIcon() {
        }

        public int getIconWidth() {
            return 36;
        }

        public int getIconHeight() {
            return 36;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
        }
    }

    static class OptionPaneCloseAction
    extends AbstractAction {
        OptionPaneCloseAction() {
        }

        public void actionPerformed(ActionEvent event) {
            JOptionPane op = (JOptionPane)event.getSource();
            op.setValue(new Integer(-1));
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            String property = e.getPropertyName();
            if (property.equals("icon") || property.equals("initialSelectionValue") || property.equals("initialValue") || property.equals("message") || property.equals("messageType") || property.equals("optionType") || property.equals("options") || property.equals("wantsInput")) {
                BasicOptionPaneUI.this.uninstallComponents();
                BasicOptionPaneUI.this.installComponents();
                BasicOptionPaneUI.this.optionPane.validate();
            }
        }
    }
}

