/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSplitPaneDivider;

public class BasicSplitPaneUI
extends SplitPaneUI {
    protected int beginDragDividerLocation;
    protected int dividerSize;
    transient int lastDragLocation = -1;
    protected static int KEYBOARD_DIVIDER_MOVE_OFFSET = 3;
    protected BasicSplitPaneDivider divider;
    protected PropertyChangeListener propertyChangeListener;
    protected FocusListener focusListener;
    protected ActionListener keyboardDownRightListener;
    protected ActionListener keyboardEndListener;
    protected ActionListener keyboardHomeListener;
    protected ActionListener keyboardResizeToggleListener;
    protected ActionListener keyboardUpLeftListener;
    protected BasicHorizontalLayoutManager layoutManager;
    protected KeyStroke dividerResizeToggleKey;
    protected KeyStroke downKey;
    protected KeyStroke endKey;
    protected KeyStroke homeKey;
    protected KeyStroke leftKey;
    protected KeyStroke rightKey;
    protected KeyStroke upKey;
    protected boolean draggingHW;
    protected static final String NON_CONTINUOUS_DIVIDER = "nonContinuousDivider";
    protected Component nonContinuousLayoutDivider;
    protected JSplitPane splitPane;
    boolean dividerLocationSet;

    public static ComponentUI createUI(JComponent x) {
        return new BasicSplitPaneUI();
    }

    public void installUI(JComponent c) {
        if (c instanceof JSplitPane) {
            this.splitPane = (JSplitPane)c;
            this.dividerLocationSet = false;
            this.installDefaults();
            this.installListeners();
            this.installKeyboardActions();
        }
    }

    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.dividerLocationSet = false;
        this.splitPane = null;
    }

    protected void installDefaults() {
        LookAndFeel.installColors(this.splitPane, "SplitPane.background", "SplitPane.foreground");
        LookAndFeel.installBorder(this.splitPane, "SplitPane.border");
        this.divider = this.createDefaultDivider();
        this.divider.setBorder(UIManager.getBorder("SplitPaneDivider.border"));
        this.resetLayoutManager();
        this.nonContinuousLayoutDivider = this.createDefaultNonContinuousLayoutDivider();
        this.splitPane.add((Component)this.divider, "divider");
        this.dividerSize = UIManager.getInt("SplitPane.dividerSize");
        this.splitPane.setDividerSize(this.dividerSize);
        this.divider.setDividerSize(this.dividerSize);
        this.splitPane.setOpaque(true);
    }

    protected void uninstallDefaults() {
        this.layoutManager = null;
        this.splitPane.remove(this.divider);
        this.divider = null;
        this.nonContinuousLayoutDivider = null;
        if (this.splitPane.getBackground() instanceof UIResource) {
            this.splitPane.setBackground(null);
        }
        if (this.splitPane.getBorder() instanceof UIResource) {
            this.splitPane.setBorder(null);
        }
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.focusListener = this.createFocusListener();
        this.splitPane.addPropertyChangeListener(this.propertyChangeListener);
        this.splitPane.addFocusListener(this.focusListener);
    }

    protected void uninstallListeners() {
        this.splitPane.removePropertyChangeListener(this.propertyChangeListener);
        this.splitPane.removeFocusListener(this.focusListener);
        this.focusListener = null;
        this.propertyChangeListener = null;
    }

    InputMap getInputMap(int condition) {
        if (condition == 1) {
            return (InputMap)UIManager.get("SplitPane.ancestorInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap map = (ActionMap)UIManager.get("SplitPane.actionMap");
        if (map == null && (map = this.createActionMap()) != null) {
            UIManager.put("SplitPane.actionMap", map);
        }
        return map;
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("toggleFocus", new AbstractAction("toggleFocus"){

            public void actionPerformed(ActionEvent event) {
            }
        });
        map.put("startResize", new AbstractAction("startResize"){

            public void actionPerformed(ActionEvent event) {
                BasicSplitPaneUI.this.splitPane.requestFocus();
            }
        });
        map.put("selectMax", new AbstractAction("selectMax"){

            public void actionPerformed(ActionEvent event) {
                BasicSplitPaneUI.this.splitPane.setDividerLocation(1.0);
            }
        });
        map.put("selectMin", new AbstractAction("selectMin"){

            public void actionPerformed(ActionEvent event) {
                BasicSplitPaneUI.this.splitPane.setDividerLocation(0.0);
            }
        });
        map.put("negativeIncrement", new AbstractAction("negativeIncrement"){

            public void actionPerformed(ActionEvent event) {
                int oldLoc = BasicSplitPaneUI.this.splitPane.getDividerLocation();
                int newLoc = Math.max(oldLoc - KEYBOARD_DIVIDER_MOVE_OFFSET, 0);
                BasicSplitPaneUI.this.splitPane.setDividerLocation(newLoc);
            }
        });
        map.put("positiveIncrement", new AbstractAction("positiveIncrement"){

            public void actionPerformed(ActionEvent event) {
                int oldLoc = BasicSplitPaneUI.this.splitPane.getDividerLocation();
                int newLoc = Math.max(oldLoc + KEYBOARD_DIVIDER_MOVE_OFFSET, 0);
                BasicSplitPaneUI.this.splitPane.setDividerLocation(newLoc);
            }
        });
        map.put("focusOutBackward", new AbstractAction("focusOutBackward"){

            public void actionPerformed(ActionEvent event) {
            }
        });
        map.put("focusOutForward", new AbstractAction("focusOutForward"){

            public void actionPerformed(ActionEvent event) {
            }
        });
        return map;
    }

    protected void installKeyboardActions() {
        InputMap keyMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.splitPane, 1, keyMap);
        ActionMap map = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.splitPane, map);
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.splitPane, null);
        SwingUtilities.replaceUIInputMap(this.splitPane, 1, null);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyHandler();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected ActionListener createKeyboardUpLeftListener() {
        return new KeyboardUpLeftHandler();
    }

    protected ActionListener createKeyboardDownRightListener() {
        return new KeyboardDownRightHandler();
    }

    protected ActionListener createKeyboardHomeListener() {
        return new KeyboardHomeHandler();
    }

    protected ActionListener createKeyboardEndListener() {
        return new KeyboardEndHandler();
    }

    protected ActionListener createKeyboardResizeToggleListener() {
        return new KeyboardResizeToggleHandler();
    }

    public int getOrientation() {
        return this.splitPane.getOrientation();
    }

    public void setOrientation(int orientation) {
        this.splitPane.setOrientation(orientation);
    }

    public boolean isContinuousLayout() {
        return this.splitPane.isContinuousLayout();
    }

    public void setContinuousLayout(boolean b) {
        this.splitPane.setContinuousLayout(b);
    }

    public int getLastDragLocation() {
        return this.lastDragLocation;
    }

    public void setLastDragLocation(int l) {
        this.lastDragLocation = l;
    }

    public BasicSplitPaneDivider getDivider() {
        return this.divider;
    }

    protected Component createDefaultNonContinuousLayoutDivider() {
        if (this.nonContinuousLayoutDivider == null) {
            this.nonContinuousLayoutDivider = new Canvas();
            Color c = UIManager.getColor("SplitPaneDivider.draggingColor");
            this.nonContinuousLayoutDivider.setBackground(c);
        }
        return this.nonContinuousLayoutDivider;
    }

    protected void setNonContinuousLayoutDivider(Component newDivider) {
        this.setNonContinuousLayoutDivider(newDivider, true);
    }

    protected void setNonContinuousLayoutDivider(Component newDivider, boolean rememberSizes) {
        this.nonContinuousLayoutDivider = newDivider;
    }

    public Component getNonContinuousLayoutDivider() {
        return this.nonContinuousLayoutDivider;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public BasicSplitPaneDivider createDefaultDivider() {
        if (this.divider == null) {
            this.divider = new BasicSplitPaneDivider(this);
        }
        return this.divider;
    }

    public void resetToPreferredSizes(JSplitPane jc) {
        this.layoutManager.resetToPreferredSizes();
    }

    public void setDividerLocation(JSplitPane jc, int location) {
        this.dividerLocationSet = true;
        this.splitPane.revalidate();
        this.splitPane.repaint();
    }

    public int getDividerLocation(JSplitPane jc) {
        int loc = jc.getOrientation() == 1 ? this.divider.getX() : this.divider.getY();
        return loc;
    }

    public int getMinimumDividerLocation(JSplitPane jc) {
        int value = this.layoutManager.getInitialLocation(jc.getInsets());
        if (this.layoutManager.components[0] != null) {
            value += this.layoutManager.minimumSizeOfComponent(0);
        }
        return value;
    }

    public int getMaximumDividerLocation(JSplitPane jc) {
        int value = this.layoutManager.getInitialLocation(jc.getInsets()) + this.layoutManager.getAvailableSize(jc.getSize(), jc.getInsets()) - this.splitPane.getDividerSize();
        if (this.layoutManager.components[1] != null) {
            value -= this.layoutManager.minimumSizeOfComponent(1);
        }
        return value;
    }

    public void finishedPaintingChildren(JSplitPane jc, Graphics g) {
        if (!this.splitPane.isContinuousLayout() && this.nonContinuousLayoutDivider != null && this.nonContinuousLayoutDivider.isVisible()) {
            SwingUtilities.paintComponent(g, this.nonContinuousLayoutDivider, null, this.nonContinuousLayoutDivider.getBounds());
        }
    }

    public void paint(Graphics g, JComponent jc) {
    }

    public Dimension getPreferredSize(JComponent jc) {
        return this.layoutManager.preferredLayoutSize(jc);
    }

    public Dimension getMinimumSize(JComponent jc) {
        return this.layoutManager.minimumLayoutSize(jc);
    }

    public Dimension getMaximumSize(JComponent jc) {
        return this.layoutManager.maximumLayoutSize(jc);
    }

    public Insets getInsets(JComponent jc) {
        return this.splitPane.getBorder().getBorderInsets(this.splitPane);
    }

    protected void resetLayoutManager() {
        this.layoutManager = this.getOrientation() == 1 ? new BasicHorizontalLayoutManager() : new BasicVerticalLayoutManager();
        this.getSplitPane().setLayout(this.layoutManager);
        this.layoutManager.updateComponents();
        this.getSplitPane().revalidate();
    }

    protected void startDragging() {
        Component left = this.splitPane.getLeftComponent();
        Component right = this.splitPane.getRightComponent();
        this.dividerSize = this.divider.getDividerSize();
        this.setLastDragLocation(-1);
        if (left != null && !left.isLightweight() || right != null && !right.isLightweight()) {
            this.draggingHW = true;
        }
        if (this.splitPane.isContinuousLayout()) {
            this.nonContinuousLayoutDivider.setVisible(false);
        } else {
            this.nonContinuousLayoutDivider.setVisible(true);
            this.nonContinuousLayoutDivider.setBounds(this.divider.getBounds());
        }
    }

    protected void dragDividerTo(int location) {
        location = this.validLocation(location);
        if (this.beginDragDividerLocation == -1) {
            this.beginDragDividerLocation = location;
        }
        if (this.splitPane.isContinuousLayout()) {
            this.splitPane.setDividerLocation(location);
        } else {
            Point p = this.nonContinuousLayoutDivider.getLocation();
            if (this.getOrientation() == 1) {
                p.x = location;
            } else {
                p.y = location;
            }
            this.nonContinuousLayoutDivider.setLocation(p);
        }
        this.setLastDragLocation(location);
        this.splitPane.repaint();
    }

    protected void finishDraggingTo(int location) {
        if (this.nonContinuousLayoutDivider != null) {
            this.nonContinuousLayoutDivider.setVisible(false);
        }
        this.draggingHW = false;
        location = this.validLocation(location);
        this.splitPane.setDividerLocation(location);
        this.splitPane.setLastDividerLocation(this.beginDragDividerLocation);
        this.beginDragDividerLocation = -1;
    }

    protected int getDividerBorderSize() {
        if (this.getOrientation() == 1) {
            return this.divider.getBorder().getBorderInsets((Component)this.divider).left;
        }
        return this.divider.getBorder().getBorderInsets((Component)this.divider).top;
    }

    private int validLocation(int location) {
        int min = this.getMinimumDividerLocation(this.splitPane);
        int max = this.getMaximumDividerLocation(this.splitPane);
        if (min > 0 && location < min) {
            return min;
        }
        if (max > 0 && location > max) {
            return max;
        }
        return location;
    }

    public class BasicHorizontalLayoutManager
    implements LayoutManager2 {
        protected Component[] components = new Component[3];
        protected int[] sizes = new int[3];
        private int axis;

        BasicHorizontalLayoutManager() {
            this(0);
        }

        BasicHorizontalLayoutManager(int a) {
            this.axis = a;
        }

        public void addLayoutComponent(Component comp, Object constraints) {
            this.addLayoutComponent((String)constraints, comp);
        }

        public void addLayoutComponent(String place, Component component) {
            int i = 0;
            if (place == null) {
                i = 2;
            } else if (place.equals("top") || place.equals("left")) {
                i = 0;
            } else if (place.equals("bottom") || place.equals("right")) {
                i = 1;
            } else {
                throw new IllegalArgumentException("Illegal placement in JSplitPane");
            }
            this.components[i] = component;
            this.resetSizeAt(i);
            BasicSplitPaneUI.this.splitPane.revalidate();
            BasicSplitPaneUI.this.splitPane.repaint();
        }

        protected int getAvailableSize(Dimension containerSize, Insets insets) {
            int size = this.axis == 0 ? containerSize.width - insets.left - insets.right : containerSize.height - insets.top - insets.bottom;
            return size;
        }

        protected int getInitialLocation(Insets insets) {
            int loc = 0;
            if (insets != null) {
                loc = this.axis == 0 ? insets.left : insets.top;
            }
            return loc;
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        protected int getPreferredSizeOfComponent(Component c) {
            int size = 0;
            Dimension dims = c.getPreferredSize();
            if (this.axis == 0) {
                if (dims != null) {
                    size = dims.width;
                }
            } else if (dims != null) {
                size = dims.height;
            }
            return size;
        }

        protected int getSizeOfComponent(Component c) {
            int size = this.axis == 0 ? c.getHeight() : c.getWidth();
            return size;
        }

        protected int[] getSizes() {
            return this.sizes;
        }

        public void invalidateLayout(Container c) {
        }

        public void layoutContainer(Container container) {
            if (container instanceof JSplitPane) {
                JSplitPane split = (JSplitPane)container;
                this.distributeExtraSpace();
                Insets insets = split.getInsets();
                Dimension dims = split.getSize();
                int loc = this.getInitialLocation(insets);
                int available = this.getAvailableSize(dims, insets);
                this.sizes[0] = split.getDividerLocation();
                this.sizes[1] = available - this.sizes[0] - this.sizes[2];
                if (!BasicSplitPaneUI.this.dividerLocationSet) {
                    this.sizes[0] = Math.max(this.sizes[0], this.minimumSizeOfComponent(0));
                    this.sizes[1] = Math.max(this.sizes[1], this.minimumSizeOfComponent(1));
                }
                this.setComponentToSize(this.components[0], this.sizes[0], loc, insets, dims);
                this.setComponentToSize(this.components[2], this.sizes[2], loc += this.sizes[0], insets, dims);
                this.setComponentToSize(this.components[1], this.sizes[1], loc += this.sizes[2], insets, dims);
            }
        }

        public Dimension maximumLayoutSize(Container target) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public Dimension minimumLayoutSize(Container target) {
            Dimension dim = new Dimension();
            if (target instanceof JSplitPane) {
                int primary = 0;
                int secondary = 0;
                int i = 0;
                while (i < this.components.length) {
                    if (this.components[i] != null) {
                        Dimension dims = this.components[i].getMinimumSize();
                        primary += this.axis == 0 ? dims.width : dims.height;
                        int sec = this.axis == 0 ? dims.height : dims.width;
                        secondary = Math.max(sec, secondary);
                    }
                    ++i;
                }
                int width = this.axis == 0 ? primary : secondary;
                int height = this.axis == 1 ? secondary : primary;
                Insets i2 = BasicSplitPaneUI.this.splitPane.getInsets();
                dim.setSize(width + i2.left + i2.right, height + i2.top + i2.bottom);
            }
            return dim;
        }

        public Dimension preferredLayoutSize(Container target) {
            Dimension dim = new Dimension();
            if (target instanceof JSplitPane) {
                int primary = 0;
                int secondary = 0;
                int i = 0;
                while (i < this.components.length) {
                    if (this.components[i] != null) {
                        Dimension dims = this.components[i].getPreferredSize();
                        primary += this.axis == 0 ? dims.width : dims.height;
                        int sec = this.axis == 0 ? dims.height : dims.width;
                        secondary = Math.max(sec, secondary);
                    }
                    ++i;
                }
                int width = this.axis == 0 ? primary : secondary;
                int height = this.axis == 1 ? secondary : primary;
                Insets i2 = BasicSplitPaneUI.this.splitPane.getInsets();
                dim.setSize(width + i2.left + i2.right, height + i2.top + i2.bottom);
            }
            return dim;
        }

        public void removeLayoutComponent(Component component) {
            int i = 0;
            while (i < this.components.length) {
                if (component == this.components[i]) {
                    this.components[i] = null;
                    this.sizes[i] = 0;
                }
                ++i;
            }
        }

        protected void resetSizeAt(int index) {
            if (this.components[index] != null) {
                this.sizes[index] = this.getPreferredSizeOfComponent(this.components[index]);
            }
        }

        public void resetToPreferredSizes() {
            int i = 0;
            while (i < this.components.length) {
                this.resetSizeAt(i);
                ++i;
            }
        }

        protected void setComponentToSize(Component c, int size, int location, Insets insets, Dimension containerSize) {
            if (insets != null) {
                if (this.axis == 0) {
                    c.setBounds(location, insets.top, size, containerSize.height - insets.top - insets.bottom);
                } else {
                    c.setBounds(insets.left, location, containerSize.width - insets.left - insets.right, size);
                }
            } else if (this.axis == 0) {
                c.setBounds(location, 0, size, containerSize.height);
            } else {
                c.setBounds(0, location, containerSize.width, size);
            }
        }

        protected void setSizes(int[] newSizes) {
            this.sizes = newSizes;
        }

        protected void updateComponents() {
            Component left = BasicSplitPaneUI.this.splitPane.getLeftComponent();
            Component right = BasicSplitPaneUI.this.splitPane.getRightComponent();
            if (left != null) {
                this.components[0] = left;
                this.resetSizeAt(0);
            }
            if (right != null) {
                this.components[1] = right;
                this.resetSizeAt(1);
            }
            this.components[2] = BasicSplitPaneUI.this.divider;
        }

        void distributeExtraSpace() {
        }

        int minimumSizeOfComponent(int index) {
            Dimension dims = this.components[index].getMinimumSize();
            int size = 0;
            if (dims != null) {
                size = this.axis == 0 ? dims.width : dims.height;
            }
            return size;
        }
    }

    public class BasicVerticalLayoutManager
    extends BasicHorizontalLayoutManager {
        public BasicVerticalLayoutManager() {
            super(1);
        }
    }

    public class FocusHandler
    extends FocusAdapter {
        public void focusGained(FocusEvent ev) {
            BasicSplitPaneUI.this.divider.repaint();
        }

        public void focusLost(FocusEvent ev) {
            BasicSplitPaneUI.this.divider.repaint();
        }
    }

    public class KeyboardDownRightHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
        }
    }

    public class KeyboardEndHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
        }
    }

    public class KeyboardHomeHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
        }
    }

    public class KeyboardResizeToggleHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
        }
    }

    public class KeyboardUpLeftHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
        }
    }

    public class PropertyHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("dividerSize")) {
                int newSize = BasicSplitPaneUI.this.splitPane.getDividerSize();
                int[] tmpSizes = BasicSplitPaneUI.this.layoutManager.getSizes();
                BasicSplitPaneUI.this.dividerSize = tmpSizes[2];
                int newSpace = newSize - tmpSizes[2];
                tmpSizes[2] = newSize;
                tmpSizes[0] = tmpSizes[0] + newSpace / 2;
                tmpSizes[1] = tmpSizes[1] + newSpace / 2;
                BasicSplitPaneUI.this.layoutManager.setSizes(tmpSizes);
            } else if (e.getPropertyName().equals("orientation")) {
                int max = BasicSplitPaneUI.this.layoutManager.getAvailableSize(BasicSplitPaneUI.this.splitPane.getSize(), BasicSplitPaneUI.this.splitPane.getInsets());
                int dividerLoc = BasicSplitPaneUI.this.getDividerLocation(BasicSplitPaneUI.this.splitPane);
                double prop = (double)dividerLoc / (double)max;
                BasicSplitPaneUI.this.resetLayoutManager();
                if (prop <= 1.0 && prop >= 0.0) {
                    BasicSplitPaneUI.this.splitPane.setDividerLocation(prop);
                }
            }
        }
    }
}

