#ifndef FELIXSERVER_DEFINITIONS_HPP
#define FELIXSERVER_DEFINITIONS_HPP

#include <cstdint>
#include <functional>

#include <netio3-backend/Netio3Backend.hpp>
#include <netio3/BufferFormatter.hpp>

namespace felix_server {
  using OnSubscriptionCallback =
    std::function<void(std::uint64_t tag, const netio3::EndPointAddress& ep)>;
  using OnUnsubscriptionCallback =
    std::function<void(std::uint64_t tag, const netio3::EndPointAddress& ep)>;
  using OnPublishCompletedCallback = std::function<void(std::uint64_t key)>;
  using OnMessageCallback = std::function<void(std::uint64_t tag, std::span<const std::uint8_t> data, std::uint8_t status)>;
  using OnBufferCallback = std::function<void(std::span<const std::uint8_t> data)>;
  using EventLoopCallback = std::function<void()>;
}  // namespace felix_server

#endif  // FELIXSERVER_DEFINITIONS_HPP