#ifndef FELIXCLIENT_BLOCK_HPP
#define FELIXCLIENT_BLOCK_HPP

#include <cstddef>
#include <cstdint>
#include <span>

namespace felix {
  /**
   * @brief Decoded block
   */
  struct Block {
    constexpr static auto lid_sequence_number_size = std::size_t{2};
    constexpr static auto sequence_number_mask = std::uint16_t{0b11111};
    constexpr static auto marker_size = std::size_t{2};
    constexpr static auto data_size = std::size_t{1020};
    constexpr static auto header_size = lid_sequence_number_size + marker_size;
    constexpr static auto block_size = data_size + header_size;

    int sequence_number{};               //!< Sequence number of the block
    std::uint16_t marker{};              //!< Marker of the block
    std::span<const std::uint8_t> data;  //!< Data of the block
  };
}  // namespace felix

#endif  // FELIXCLIENT_BLOCK_HPP