#ifndef FELIX_DATA_STRUCTURES_H_
#define FELIX_DATA_STRUCTURES_H_

#include <cstdint>
#include <sys/uio.h>

#define BLOCK_HEADER_SIZE  (4)

namespace felix_readout {

    struct Block {
        uint32_t elink :11;
        uint32_t sequence_number :5;
        uint16_t marker;
        uint8_t data[1020];
    } __attribute__((packed));


    union subchunk_trailer_t
    {
        struct
        { // 32-bit trailer
            uint32_t length   : 16;
            uint32_t unused   :  9;
            uint32_t busymask :  1;
            uint32_t crcerr   :  1;
            uint32_t err      :  1;
            uint32_t trunc    :  1;
            uint32_t type     :  3;
        } __attribute__((packed)) data;
        uint32_t value;
    };


    struct subchunk_t {
        uint32_t pos;
        subchunk_trailer_t trailer;
    };

}

#endif /* FELIX_DATA_STRUCTURES_H_ */