#include <stdexcept>
#include <format>

namespace felix_readout
{

    struct FelixException : public std::runtime_error {
        FelixException(std::string const& message) : std::runtime_error(message) {}
    };

    struct FelixBufferException : FelixException {
        FelixBufferException(std::string const& message) : FelixException(message) {}
    };

    struct FelixExceptionNoDevice : public FelixException {
        FelixExceptionNoDevice(int dev_no) : FelixException(std::format("Device {} does not exist", dev_no)) {}
    };

    struct FelixExceptionCannotOpen : public FelixException {
        FelixExceptionCannotOpen(std::string const& message) : FelixException(message) {}
    };

    struct FelixExceptionInvalidDmaId : public FelixException {
        FelixExceptionInvalidDmaId(std::string const& message) : FelixException(message) {}
    };

    struct FelixExceptionInvalidDmaOp : public FelixException {
        FelixExceptionInvalidDmaOp(std::string const& message) : FelixException(message) {}
    };



}