#ifndef NETIO3_SUBSCRIPTIONENDPOINTCONTAINER_DEFINITION_HPP
#define NETIO3_SUBSCRIPTIONENDPOINTCONTAINER_DEFINITION_HPP

#include <cstdint>
#include <concepts>
#include <functional>
#include <vector>

#include "netio3/NetioSender.hpp"

namespace netio3 {
  template<typename Container, typename... Args>
  concept SubscriptionEndpointContainer = requires(Container container,
                                                   const Container const_container,
                                                   std::uint64_t tag) {
    { container.at(tag) } -> std::convertible_to<std::vector<std::reference_wrapper<NetioSender::Connection>>>;
    { const_container.at(tag) } -> std::convertible_to<const std::vector<std::reference_wrapper<NetioSender::Connection>>>;
    { container.contains(tag) } -> std::same_as<bool>;
    { container.erase(tag) };
    { container.add(tag) };
  };
}  // namespace netio3

#endif  // NETIO3_SUBSCRIPTIONENDPOINTCONTAINER_DEFINITION_HPP