#ifndef NETIO3_SUBSCRIPTIONREQUEST_HPP
#define NETIO3_SUBSCRIPTIONREQUEST_HPP

#include <cstdint>
#include <string>

namespace netio3 {
    /**
     * @brief Struct for a subscription request
     */
    struct [[gnu::visibility("default")]] SubscriptionRequest {
        enum class Sub : uint8_t { UNSUBSCRIBE = 0, SUBSCRIBE = 1 };
        std::uint64_t tag{};
        std::string addr{};
        std::uint16_t data_port{};
        std::uint16_t ack_port{};
        Sub subscribe{};

        /**
         * @brief Serialize a SubscriptionRequest to a JSON string
         *
         * @param req The SubscriptionRequest to serialize
         * @return The JSON string
         */
        [[nodiscard]] static std::string to_json(const SubscriptionRequest& req);

        /**
         * @brief Deserialize a SubscriptionRequest from a JSON string
         *
         * @param req The JSON string to deserialize
         * @throws SubscriptionParseError if the JSON is invalid
         * @return The SubscriptionRequest
         */
        [[nodiscard]] static SubscriptionRequest from_json(const std::string& req);
    };

}  // namespace netio3

#endif  // NETIO3_SUBSCRIPTIONREQUEST_HPP