#ifndef NETIO3_TYPES_HPP
#define NETIO3_TYPES_HPP

#include <format>
#include <map>
#include <stdexcept>
#include <string>

namespace netio3 {
    /**
     * @brief Enum class for the different send methods
     */
    enum class SendMethod { SEND, BUFFERED, ZERO_COPY };

    /**
     * @brief Function to convert a string to a SendMethod enum
     *
     * @throws std::invalid_argument if the string is not a valid SendMethod
     * @param method The string representation of the SendMethod
     * @return The SendMethod enum
     */
    [[nodiscard]] inline static SendMethod send_method_from_string(const std::string& method) {
        static std::map<std::string, SendMethod> send_method_value{
          {"SEND", SendMethod::SEND},
          {"BUFFERED", SendMethod::BUFFERED},
          {"ZERO_COPY", SendMethod::ZERO_COPY}};
        if (send_method_value.contains(method)) {
            return send_method_value.at(method);
        }
        throw std::invalid_argument(std::format("send_method: {}", method));
    }
}  // namespace netio3

#endif  // NETIO3_TYPES_HPP