if (NOT DEFINED CPM_DONT_UPDATE_MODULE_PATH)
  set(CPM_DONT_UPDATE_MODULE_PATH ON CACHE BOOL "")
endif()

include(CPM)

set(OVERWRITE_VERSIONS OFF CACHE BOOL "Force overwrite versions of dependencies")
set(VERSIONS_DOWNLOAD_SCRIPT "${CMAKE_CURRENT_SOURCE_DIR}/cmake_tdaq/scripts/download_versions.py")
set(VERSIONS_URL "https://gitlab.cern.ch/atlas-tdaq-felix/felix-dependency-registry")
set(VERSIONS_BRANCH "master")
set(VERSIONS_FILE_NAME "versions.cmake")
set(VERSIONS_TARGET "${CMAKE_BINARY_DIR}/${VERSIONS_FILE_NAME}")

if(NOT DEFINED VERSIONS_DOWNLOADED)
  message(STATUS "Downloading versions from ${VERSIONS_URL} on branch ${VERSIONS_BRANCH} to ${VERSIONS_TARGET}")

  if(${OVERWRITE_VERSIONS})
    message(STATUS "Overwriting versions")
    execute_process(COMMAND python3 ${VERSIONS_DOWNLOAD_SCRIPT} --url ${VERSIONS_URL} --branch ${VERSIONS_BRANCH} --existing-file-path ${VERSIONS_TARGET} --force)
  else()
    execute_process(COMMAND python3 ${VERSIONS_DOWNLOAD_SCRIPT} --url ${VERSIONS_URL} --branch ${VERSIONS_BRANCH} --existing-file-path ${VERSIONS_TARGET})
  endif()

  set(VERSIONS_DOWNLOADED TRUE "Versions have been downloaded")
endif()

include(${VERSIONS_TARGET})

function(cpm_add_felix)
  set(options)
  set(oneValueArgs NAME GIT_REPOSITORY GIT_TAG BINARY_TAG)
  set(multiValueArgs)
  cmake_parse_arguments(CPM_ADD_FELIX "${options}" "${oneValueArgs}" "${multiValueArgs}" ${ARGN})

  message(STATUS "add package " ${PROJECT_NAME} " - " ${CPM_ADD_FELIX_NAME})
  if (NOT PROJECT_NAME STREQUAL ${CPM_ADD_FELIX_NAME})
    CPMAddPackage(
      NAME ${CPM_ADD_FELIX_NAME}
      GIT_REPOSITORY ${CPM_ADD_FELIX_GIT_REPOSITORY}
      GIT_TAG ${CPM_ADD_FELIX_GIT_TAG}
      GIT_NO_SUBMODULES ON
    )
    cpm_export_variables(${CPM_ADD_FELIX_NAME})
  endif()
endfunction(cpm_add_felix)

function(cpm_add_external_not_precompiled_package)
  set(options)
  set(oneValueArgs NAME GIT_REPOSITORY GIT_TAG BINARY_TAG)
  set(multiValueArgs)
  cmake_parse_arguments(CPM_ADD_EXTERNAL "${options}" "${oneValueArgs}" "${multiValueArgs}" ${ARGN})

  message(STATUS "add package " ${PROJECT_NAME} " - " ${CPM_ADD_EXTERNAL_NAME})
  if (NOT PROJECT_NAME STREQUAL ${CPM_ADD_EXTERNAL_NAME})
    CPMAddPackage(
      NAME ${CPM_ADD_EXTERNAL_NAME}
      GIT_REPOSITORY ${CPM_ADD_EXTERNAL_GIT_REPOSITORY}
      GIT_TAG ${CPM_ADD_EXTERNAL_GIT_TAG}
    )
    cpm_export_variables(${CPM_ADD_EXTERNAL_NAME})
  endif()
endfunction(cpm_add_external_not_precompiled_package)

function(reverse_list list_name output_list_name)
  set(reversed_list)
  foreach(item IN LISTS ${list_name})
    list(INSERT reversed_list 0 ${item})
  endforeach()
  set(${output_list_name} "${reversed_list}" PARENT_SCOPE)
endfunction()

function(_felix_install_external)
  set(options)
  set(oneValueArgs NAME PATH)
  set(multiValueArgs)
  cmake_parse_arguments(EXT_PACKAGE "${options}" "${oneValueArgs}" "${multiValueArgs}" ${ARGN})

  # Install the include directory
  install(DIRECTORY "${EXT_PACKAGE_PATH}/include/" DESTINATION include
          FILES_MATCHING PATTERN "*.h" PATTERN "*.hpp" PATTERN "*.hh" PATTERN "*.inc")

  # Install the library files
  # Assume libraries are in lib or lib64 directories
  file(GLOB LIB_FILES
      "${EXT_PACKAGE_PATH}/lib/*.so*"
      "${EXT_PACKAGE_PATH}/lib/*.a"
      "${EXT_PACKAGE_PATH}/lib64/*.so*"
      "${EXT_PACKAGE_PATH}/lib64/*.a"
  )
  install(FILES ${LIB_FILES} DESTINATION lib OPTIONAL)
endfunction(_felix_install_external)

function(_felix_add_external_with_config)
  set(options)
  set(oneValueArgs NAME VERSION BASE_PATH)
  set(multiValueArgs)
  cmake_parse_arguments(EXT_PACKAGE "${options}" "${oneValueArgs}" "${multiValueArgs}" ${ARGN})

  set(${EXT_PACKAGE_NAME}_ROOT "${EXT_PACKAGE_BASE_PATH}/${EXT_PACKAGE_VERSION}/${BINARY_TAG}")

  find_package(${EXT_PACKAGE_NAME} REQUIRED CONFIG)

  _felix_install_external(PATH ${${EXT_PACKAGE_NAME}_ROOT})
endfunction(_felix_add_external_with_config)

function(felix_add_lcg_external)
  set(options)
  set(oneValueArgs NAME DIRNAME VERSION)
  set(multiValueArgs)
  cmake_parse_arguments(EXT_PACKAGE "${options}" "${oneValueArgs}" "${multiValueArgs}" ${ARGN})

  if(NOT EXT_PACKAGE_DIRNAME)
    set(EXT_PACKAGE_DIRNAME ${EXT_PACKAGE_NAME})
  endif()

  set(base_path "${LCG_RELEASE_BASE}/LCG_${LCG_VERSION}/${EXT_PACKAGE_DIRNAME}")
  _felix_add_external_with_config(NAME ${EXT_PACKAGE_NAME} VERSION ${EXT_PACKAGE_VERSION} BASE_PATH ${base_path})
endfunction(felix_add_lcg_external)

function(felix_add_external_with_config)
  set(options)
  set(oneValueArgs NAME VERSION GIT_REPOSITORY GIT_TAG)
  set(multiValueArgs)
  cmake_parse_arguments(EXT_PACKAGE "${options}" "${oneValueArgs}" "${multiValueArgs}" ${ARGN})

  CPMAddPackage(
    NAME ${EXT_PACKAGE_NAME}
    VERSION ${EXT_PACKAGE_VERSION}
    GIT_REPOSITORY ${EXT_PACKAGE_GIT_REPOSITORY}
    GIT_TAG ${EXT_PACKAGE_GIT_TAG}
    DOWNLOAD_ONLY YES
  )

  set(base_path "${${EXT_PACKAGE_NAME}_SOURCE_DIR}")

  _felix_add_external_with_config(NAME ${EXT_PACKAGE_NAME} VERSION ${EXT_PACKAGE_VERSION} BASE_PATH ${base_path})
endfunction(felix_add_external_with_config)

function(felix_add_external_with_module)
  set(options)
  set(oneValueArgs NAME VERSION GIT_REPOSITORY GIT_TAG BINARY_TAG)
  set(multiValueArgs)
  cmake_parse_arguments(EXT_PACKAGE "${options}" "${oneValueArgs}" "${multiValueArgs}" ${ARGN})

  CPMAddPackage(
    NAME ${EXT_PACKAGE_NAME}
    VERSION ${EXT_PACKAGE_VERSION}
    GIT_REPOSITORY ${EXT_PACKAGE_GIT_REPOSITORY}
    GIT_TAG ${EXT_PACKAGE_GIT_TAG}
    DOWNLOAD_ONLY YES
  )

  set(${EXT_PACKAGE_NAME}_ROOT "${${EXT_PACKAGE_NAME}_SOURCE_DIR}/${EXT_PACKAGE_VERSION}/${EXT_PACKAGE_BINARY_TAG}")
  find_package(${EXT_PACKAGE_NAME} ${EXT_PACKAGE_VERSION} REQUIRED)

  _felix_install_external(PATH ${${EXT_PACKAGE_NAME}_ROOT})
endfunction(felix_add_external_with_module)

# Define a function to include dependencies based on a list of names
function(felix_add_dependency)
  set(options "")
  set(oneValueArgs "")
  set(multiValueArgs DEPENDENCIES)
  cmake_parse_arguments(PARSE_ARGV 0 ARG "${options}" "${oneValueArgs}" "${multiValueArgs}")

  set(felix_external_lcg "json" "yaml-cpp" "absl")

  foreach(NAME IN LISTS ARG_DEPENDENCIES)
    message(STATUS "add dependency " ${PROJECT_NAME} " - " ${NAME})
    string(REPLACE "-" "_" NAME_UNDERSCORE ${NAME})

    set(tag "${${NAME_UNDERSCORE}_tag}")
    set(repo "${${NAME_UNDERSCORE}_repo}")

    if (PROJECT_NAME STREQUAL ${NAME})
      message(WARNING "Project name is the same as the dependency name. Skipping ${NAME}")
      continue()
    elseif(NAME IN_LIST felix_external_with_module)
      felix_add_external_with_module(
        NAME ${NAME}
        VERSION ${${NAME_UNDERSCORE}_version}
        GIT_REPOSITORY ${repo}
        GIT_TAG ${tag}
        BINARY_TAG ${BINARY_TAG}
      )
    elseif(NAME IN_LIST felix_external_with_module_no_bin_tag)
      felix_add_external_with_module(
        NAME ${NAME}
        VERSION ${${NAME_UNDERSCORE}_version}
        GIT_REPOSITORY ${repo}
        GIT_TAG ${tag}
        BINARY_TAG ""
      )
    elseif(NAME IN_LIST felix_external_lcg)
      set(dirname ${NAME})
      if(NAME STREQUAL "json")
        set(dirname "jsonmcpp")
        set(NAME "nlohmann_json")
      elseif(NAME STREQUAL "yaml-cpp")
        set(dirname "yamlcpp")
      endif()
      felix_add_lcg_external(
        NAME ${NAME}
        DIRNAME ${dirname}
        VERSION ${${NAME_UNDERSCORE}_version}
      )
    elseif(NAME IN_LIST felix_external_with_config)
      if(NAME STREQUAL "catch")
        set(NAME "Catch2")
      endif()
      felix_add_external_with_config(
        NAME ${NAME}
        VERSION ${${NAME_UNDERSCORE}_version}
        GIT_REPOSITORY ${repo}
        GIT_TAG ${tag}
        BINARY_TAG ${BINARY_TAG}
      )
    elseif(NAME IN_LIST felix_internal_packages)
      cpm_add_felix(
        NAME ${NAME}
        GIT_REPOSITORY ${repo}
        GIT_TAG ${tag}
      )
      cpm_export_variables(${NAME})
    elseif(NAME IN_LIST felix_external_not_precompiled_packages)
      cpm_add_external_not_precompiled_package(
        NAME ${NAME}
        GIT_REPOSITORY ${repo}
        GIT_TAG ${tag}
      )
      cpm_export_variables(${NAME})
    else()
      message(FATAL_ERROR "Unknown package ${NAME}")
    endif()
  endforeach()
endfunction()
