#[=======================================================================[.rst:
Findlibfabric
-------------

Finds the libfabric library.

Imported Targets
^^^^^^^^^^^^^^^^

This module provides the following imported targets, if found:

``libfabric::libfabric``
  The libfabric library

Result Variables
^^^^^^^^^^^^^^^^

This will define the following variables:

``libfabric_FOUND``
  True if the system has the libfabric library.
``libfabric_VERSION``
  The version of the libfabric library which was found.

#]=======================================================================]

find_path(libfabric_INCLUDE_DIR
  NAMES rdma/fabric.h
  PATHS ${libfabric_ROOT}/include
  PATH_SUFFIXES libfabric
  NO_CACHE
)
find_library(libfabric_LIBRARY
  NAMES fabric
  PATHS ${libfabric_ROOT}/lib
  NO_CACHE
)

find_package(PkgConfig)
if(PKG_CONFIG_FOUND)
  set(ENV{PKG_CONFIG_PATH} "${libfabric_ROOT}/lib/pkgconfig:$ENV{PKG_CONFIG_PATH}")
  pkg_check_modules(PKG_LIBFABRIC libfabric QUIET)
  if(PKG_LIBFABRIC_FOUND)
    set(libfabric_VERSION "${PKG_LIBFABRIC_VERSION}")
  endif()
endif()

# If not found via pkg-config, derive from the libfabric_ROOT path or any fallback
if(NOT libfabric_VERSION)
  # Example approach: parse the tail of libfabric_ROOT
  # e.g. /path/to/libfabric/V1.2.3/x86_64 => libfabric_VERSION = V1.2.3
  if(libfabric_ROOT)
    string(REGEX REPLACE "^.*/([^/]+)/[^/]+$" "\\1" libfabric_VERSION "${libfabric_ROOT}")
  endif()
endif()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(libfabric
  FOUND_VAR libfabric_FOUND
  REQUIRED_VARS libfabric_LIBRARY libfabric_INCLUDE_DIR
  VERSION_VAR libfabric_VERSION
)

if(libfabric_FOUND AND NOT TARGET libfabric::libfabric)
  add_library(libfabric::libfabric UNKNOWN IMPORTED)
  set_target_properties(libfabric::libfabric PROPERTIES
    IMPORTED_LOCATION "${libfabric_LIBRARY}"
    INTERFACE_INCLUDE_DIRECTORIES "${libfabric_INCLUDE_DIR}"
  )
endif()