# Set a default build type if none was specified
if(NOT CMAKE_BUILD_TYPE AND NOT CMAKE_CONFIGURATION_TYPES)
  message(STATUS "Setting build type to 'RelWithDebInfo' as none was specified.")
  set(CMAKE_BUILD_TYPE
      RelWithDebInfo
      CACHE STRING "Choose the type of build." FORCE)
  # Set the possible values of build type for cmake-gui, ccmake
  set_property(
    CACHE CMAKE_BUILD_TYPE
    PROPERTY STRINGS
             "Debug"
             "Release"
             "MinSizeRel"
             "RelWithDebInfo")
endif()

# Generate compile_commands.json to make it easier to work with clang based tools
set(CMAKE_EXPORT_COMPILE_COMMANDS ON)

if (NOT DEFINED CMAKE_CXX_STANDARD)
  set(CMAKE_CXX_STANDARD 20)
endif()

# FELIX settings
set(BUILD_SHARED_LIBS ON)
set(CMAKE_INCLUDE_CURRENT_DIR ON)

# Tracy
if (NOT DEFINED TRACY_ENABLE)
  set(TRACY_ENABLE OFF CACHE BOOL "")
endif()
if (NOT DEFINED TRACY_ON_DEMAND)
  set(TRACY_ON_DEMAND ON CACHE BOOL "")
endif()

# Function to remove all definitions starting with a specific prefix
function(remove_definitions_with_prefix prefix)
    # Get all current definitions
    get_directory_property(definitions COMPILE_DEFINITIONS)

    # Iterate over definitions and remove those that match the prefix
    foreach(definition ${definitions})
    if(definition MATCHES "^${prefix}")
      remove_definitions(-D${definition})
    endif()
    endforeach()
endfunction()
