#!/bin/bash

#This file is derived from /Hardware/TTCfx/Si5345_RegisterMap40.079/*
 # Si5345 Rev B Configuration Register Export Header File
 #
 # This file represents a series of Silicon Labs Si5345 Rev B
 # register writes that can be performed to load a single configuration
 # on a device. It was created by a Silicon Labs ClockBuilder Pro
 # export tool.
 #
 # Part:		                                       Si5345 Rev B
 # Design ID:                                          si40_240
 # Includes Pre/Post Download Control Register Writes: Yes
 # Created By:                                         ClockBuilder Pro v2.8 [2016-04-24]
 # Timestamp:                                          2016-05-09 17:37:43 GMT+03:00
 #
 # A complete design report corresponding to this export is included at the end
 # of this header file.flx-i2c r 1:0:0x68  0x0B25
 #

echo " Hard resetting the Si5345"
flx-config set HK_CTRL_FMC_SI5345_SEL=0x01
# INSEL 0: FPGA (LA01) 1: FMC OSC 2: FPGA (LA18)
flx-config set HK_CTRL_FMC_SI5345_INSEL=0x00
flx-config set HK_CTRL_FMC_SI5345_OE=0x01
sleep .1
flx-config set HK_CTRL_FMC_SI5345_RSTN=0x00
sleep 1
flx-config set HK_CTRL_FMC_SI5345_RSTN=0x01

echo " Beginning configuration process..."

#turn the page to B
flx-i2c w 1:0:0x68  0x0001 0x0B
# this is registers set on page B
# initialize confi sequence
flx-i2c w 1:0:0x68  0x0B24 0xD8
flx-i2c w 1:0:0x68  0x0B25 0x00
# wait for 300 ms minimum
sleep .5
#turn the page to 0
flx-i2c w 1:0:0x68  0x0001 0x00
# this is registers set on page 0
#Don't touch i2c address: flx-i2c w 1:0:0x68  0x000B 0x04
flx-i2c w 1:0:0x68  0x0016 0x02
flx-i2c w 1:0:0x68  0x0017 0x1C
flx-i2c w 1:0:0x68  0x0018 0x44
flx-i2c w 1:0:0x68  0x0019 0xDD
flx-i2c w 1:0:0x68  0x001A 0xDF
flx-i2c w 1:0:0x68  0x002B 0x02
#flx-i2c w 1:0:0x68  0x002C 0x0B
#Enable LOS detection for IN1, IN2, IN3 and IN4
flx-i2c w 1:0:0x68  0x002C 0x0F
flx-i2c w 1:0:0x68  0x002D 0x45
flx-i2c w 1:0:0x68  0x002E 0x46
flx-i2c w 1:0:0x68  0x002F 0x00
flx-i2c w 1:0:0x68  0x0030 0x46
flx-i2c w 1:0:0x68  0x0031 0x00
flx-i2c w 1:0:0x68  0x0032 0x00
flx-i2c w 1:0:0x68  0x0033 0x00
flx-i2c w 1:0:0x68  0x0034 0x46
flx-i2c w 1:0:0x68  0x0035 0x00
flx-i2c w 1:0:0x68  0x0036 0x46
flx-i2c w 1:0:0x68  0x0037 0x00
flx-i2c w 1:0:0x68  0x0038 0x46
flx-i2c w 1:0:0x68  0x0039 0x00
flx-i2c w 1:0:0x68  0x003A 0x00
flx-i2c w 1:0:0x68  0x003B 0x00
flx-i2c w 1:0:0x68  0x003C 0x46
flx-i2c w 1:0:0x68  0x003D 0x00
flx-i2c w 1:0:0x68  0x003F 0xBB
flx-i2c w 1:0:0x68  0x0040 0x04
flx-i2c w 1:0:0x68  0x0041 0x0C
flx-i2c w 1:0:0x68  0x0042 0x0C
flx-i2c w 1:0:0x68  0x0043 0x00
flx-i2c w 1:0:0x68  0x0044 0x0C
flx-i2c w 1:0:0x68  0x0045 0x0C
flx-i2c w 1:0:0x68  0x0046 0x32
flx-i2c w 1:0:0x68  0x0047 0x32
flx-i2c w 1:0:0x68  0x0048 0x00
flx-i2c w 1:0:0x68  0x0049 0x32
flx-i2c w 1:0:0x68  0x004A 0x32
flx-i2c w 1:0:0x68  0x004B 0x32
flx-i2c w 1:0:0x68  0x004C 0x00
flx-i2c w 1:0:0x68  0x004D 0x32
flx-i2c w 1:0:0x68  0x004E 0x55
flx-i2c w 1:0:0x68  0x004F 0x50
flx-i2c w 1:0:0x68  0x0051 0x03
flx-i2c w 1:0:0x68  0x0052 0x03
flx-i2c w 1:0:0x68  0x0053 0x00
flx-i2c w 1:0:0x68  0x0054 0x03
flx-i2c w 1:0:0x68  0x0055 0x03
flx-i2c w 1:0:0x68  0x0056 0x03
flx-i2c w 1:0:0x68  0x0057 0x00
flx-i2c w 1:0:0x68  0x0058 0x03
flx-i2c w 1:0:0x68  0x0059 0xCF
flx-i2c w 1:0:0x68  0x005A 0x31
flx-i2c w 1:0:0x68  0x005B 0xC1
flx-i2c w 1:0:0x68  0x005C 0xD5
flx-i2c w 1:0:0x68  0x005D 0x00
flx-i2c w 1:0:0x68  0x005E 0x31
flx-i2c w 1:0:0x68  0x005F 0xC1
flx-i2c w 1:0:0x68  0x0060 0xD5
flx-i2c w 1:0:0x68  0x0061 0x00
flx-i2c w 1:0:0x68  0x0062 0x00
flx-i2c w 1:0:0x68  0x0063 0x00
flx-i2c w 1:0:0x68  0x0064 0x00
flx-i2c w 1:0:0x68  0x0065 0x00
flx-i2c w 1:0:0x68  0x0066 0x31
flx-i2c w 1:0:0x68  0x0067 0xC1
flx-i2c w 1:0:0x68  0x0068 0xD5
flx-i2c w 1:0:0x68  0x0069 0x00
flx-i2c w 1:0:0x68  0x0092 0x00
flx-i2c w 1:0:0x68  0x0093 0x00
flx-i2c w 1:0:0x68  0x0095 0x00
flx-i2c w 1:0:0x68  0x0096 0x00
flx-i2c w 1:0:0x68  0x0098 0x00
flx-i2c w 1:0:0x68  0x009A 0x02
flx-i2c w 1:0:0x68  0x009B 0x30
flx-i2c w 1:0:0x68  0x009D 0x00
flx-i2c w 1:0:0x68  0x009E 0x00
#flx-i2c w 1:0:0x68  0x009E 0x50
flx-i2c w 1:0:0x68  0x00A0 0x30
flx-i2c w 1:0:0x68  0x00A2 0x02
flx-i2c w 1:0:0x68  0x00A8 0xF7
flx-i2c w 1:0:0x68  0x00A9 0x1F
flx-i2c w 1:0:0x68  0x00AA 0x01
flx-i2c w 1:0:0x68  0x00AB 0x00
flx-i2c w 1:0:0x68  0x00AC 0x00
#turn the page to 1
flx-i2c w 1:0:0x68  0x0001 0x01
# this is registers set on page 1
flx-i2c w 1:0:0x68  0x0002 0x01
flx-i2c w 1:0:0x68  0x0008 0x06
flx-i2c w 1:0:0x68  0x0009 0x09
flx-i2c w 1:0:0x68  0x000A 0x3D
flx-i2c w 1:0:0x68  0x000B 0x00
flx-i2c w 1:0:0x68  0x000D 0x06
flx-i2c w 1:0:0x68  0x000E 0x09
flx-i2c w 1:0:0x68  0x000F 0x3D
flx-i2c w 1:0:0x68  0x0010 0x00
flx-i2c w 1:0:0x68  0x0012 0x06
flx-i2c w 1:0:0x68  0x0013 0x09
flx-i2c w 1:0:0x68  0x0014 0x3D
flx-i2c w 1:0:0x68  0x0015 0x00
flx-i2c w 1:0:0x68  0x0017 0x06
flx-i2c w 1:0:0x68  0x0018 0x09
flx-i2c w 1:0:0x68  0x0019 0x3D
flx-i2c w 1:0:0x68  0x001A 0x00
flx-i2c w 1:0:0x68  0x001C 0x01
flx-i2c w 1:0:0x68  0x001D 0x09
flx-i2c w 1:0:0x68  0x001E 0x3B
flx-i2c w 1:0:0x68  0x001F 0x00
flx-i2c w 1:0:0x68  0x0021 0x01
flx-i2c w 1:0:0x68  0x0022 0x09
flx-i2c w 1:0:0x68  0x0023 0x3B
flx-i2c w 1:0:0x68  0x0024 0x00
flx-i2c w 1:0:0x68  0x0026 0x01
flx-i2c w 1:0:0x68  0x0027 0x09
flx-i2c w 1:0:0x68  0x0028 0x3B
flx-i2c w 1:0:0x68  0x0029 0x00
flx-i2c w 1:0:0x68  0x002B 0x01
flx-i2c w 1:0:0x68  0x002C 0x09
flx-i2c w 1:0:0x68  0x002D 0x3B
flx-i2c w 1:0:0x68  0x002E 0x00
flx-i2c w 1:0:0x68  0x0030 0x01
flx-i2c w 1:0:0x68  0x0031 0x09
flx-i2c w 1:0:0x68  0x0032 0x3B
flx-i2c w 1:0:0x68  0x0033 0x00
flx-i2c w 1:0:0x68  0x003A 0x02
flx-i2c w 1:0:0x68  0x003B 0x09
flx-i2c w 1:0:0x68  0x003C 0x3D
flx-i2c w 1:0:0x68  0x003D 0x00
flx-i2c w 1:0:0x68  0x003F 0x00
flx-i2c w 1:0:0x68  0x0040 0x08
flx-i2c w 1:0:0x68  0x0041 0x40
flx-i2c w 1:0:0x68  0x0042 0xFF
#turn the page to 2
flx-i2c w 1:0:0x68  0x0001 0x02
# this is registers set on page 2
flx-i2c w 1:0:0x68  0x0002 0x00
flx-i2c w 1:0:0x68  0x0003 0x00
flx-i2c w 1:0:0x68  0x0004 0x00
flx-i2c w 1:0:0x68  0x0005 0x00
flx-i2c w 1:0:0x68  0x0006 0x00
flx-i2c w 1:0:0x68  0x0008 0x19
flx-i2c w 1:0:0x68  0x0009 0x00
flx-i2c w 1:0:0x68  0x000A 0x00
flx-i2c w 1:0:0x68  0x000B 0x00
flx-i2c w 1:0:0x68  0x000C 0x00
flx-i2c w 1:0:0x68  0x000D 0x00
flx-i2c w 1:0:0x68  0x000E 0x01
flx-i2c w 1:0:0x68  0x000F 0x00
flx-i2c w 1:0:0x68  0x0010 0x00
flx-i2c w 1:0:0x68  0x0011 0x00
flx-i2c w 1:0:0x68  0x0012 0x19
flx-i2c w 1:0:0x68  0x0013 0x00
flx-i2c w 1:0:0x68  0x0014 0x00
flx-i2c w 1:0:0x68  0x0015 0x00
flx-i2c w 1:0:0x68  0x0016 0x00
flx-i2c w 1:0:0x68  0x0017 0x00
flx-i2c w 1:0:0x68  0x0018 0x01
flx-i2c w 1:0:0x68  0x0019 0x00
flx-i2c w 1:0:0x68  0x001A 0x00
flx-i2c w 1:0:0x68  0x001B 0x00
flx-i2c w 1:0:0x68  0x001C 0x00
flx-i2c w 1:0:0x68  0x001D 0x00
flx-i2c w 1:0:0x68  0x001E 0x00
flx-i2c w 1:0:0x68  0x001F 0x00
flx-i2c w 1:0:0x68  0x0020 0x00
flx-i2c w 1:0:0x68  0x0021 0x00
flx-i2c w 1:0:0x68  0x0022 0x00
flx-i2c w 1:0:0x68  0x0023 0x00
flx-i2c w 1:0:0x68  0x0024 0x00
flx-i2c w 1:0:0x68  0x0025 0x00
flx-i2c w 1:0:0x68  0x0026 0x19
flx-i2c w 1:0:0x68  0x0027 0x00
flx-i2c w 1:0:0x68  0x0028 0x00
flx-i2c w 1:0:0x68  0x0029 0x00
flx-i2c w 1:0:0x68  0x002A 0x00
flx-i2c w 1:0:0x68  0x002B 0x00
flx-i2c w 1:0:0x68  0x002C 0x01
flx-i2c w 1:0:0x68  0x002D 0x00
flx-i2c w 1:0:0x68  0x002E 0x00
flx-i2c w 1:0:0x68  0x002F 0x00
flx-i2c w 1:0:0x68  0x0031 0x01
flx-i2c w 1:0:0x68  0x0032 0x01
flx-i2c w 1:0:0x68  0x0033 0x01
flx-i2c w 1:0:0x68  0x0034 0x01
flx-i2c w 1:0:0x68  0x0035 0x00
flx-i2c w 1:0:0x68  0x0036 0x00
flx-i2c w 1:0:0x68  0x0037 0x30
flx-i2c w 1:0:0x68  0x0038 0xC3
flx-i2c w 1:0:0x68  0x0039 0x1B
flx-i2c w 1:0:0x68  0x003A 0x01
flx-i2c w 1:0:0x68  0x003B 0x00
flx-i2c w 1:0:0x68  0x003C 0x00
flx-i2c w 1:0:0x68  0x003D 0x00
flx-i2c w 1:0:0x68  0x003E 0xFA
flx-i2c w 1:0:0x68  0x004A 0x00
flx-i2c w 1:0:0x68  0x004B 0x00
flx-i2c w 1:0:0x68  0x004C 0x00
flx-i2c w 1:0:0x68  0x004D 0x00
flx-i2c w 1:0:0x68  0x004E 0x00
flx-i2c w 1:0:0x68  0x004F 0x00
flx-i2c w 1:0:0x68  0x0050 0x00
flx-i2c w 1:0:0x68  0x0051 0x00
flx-i2c w 1:0:0x68  0x0052 0x00
flx-i2c w 1:0:0x68  0x0053 0x00
flx-i2c w 1:0:0x68  0x0054 0x00
flx-i2c w 1:0:0x68  0x0055 0x00
flx-i2c w 1:0:0x68  0x0056 0x00
flx-i2c w 1:0:0x68  0x0057 0x00
flx-i2c w 1:0:0x68  0x0058 0x00
flx-i2c w 1:0:0x68  0x0059 0x00
flx-i2c w 1:0:0x68  0x005A 0x00
flx-i2c w 1:0:0x68  0x005B 0x00
flx-i2c w 1:0:0x68  0x005C 0x00
flx-i2c w 1:0:0x68  0x005D 0x00
flx-i2c w 1:0:0x68  0x005E 0x00
flx-i2c w 1:0:0x68  0x005F 0x00
flx-i2c w 1:0:0x68  0x0060 0x00
flx-i2c w 1:0:0x68  0x0061 0x00
flx-i2c w 1:0:0x68  0x0062 0x00
flx-i2c w 1:0:0x68  0x0063 0x00
flx-i2c w 1:0:0x68  0x0064 0x00
flx-i2c w 1:0:0x68  0x0068 0x05
flx-i2c w 1:0:0x68  0x0069 0x00
flx-i2c w 1:0:0x68  0x006A 0x00
flx-i2c w 1:0:0x68  0x006B 0x73
flx-i2c w 1:0:0x68  0x006C 0x69
flx-i2c w 1:0:0x68  0x006D 0x34
flx-i2c w 1:0:0x68  0x006E 0x30
flx-i2c w 1:0:0x68  0x006F 0x5F
flx-i2c w 1:0:0x68  0x0070 0x32
flx-i2c w 1:0:0x68  0x0071 0x34
flx-i2c w 1:0:0x68  0x0072 0x30
#turn the page to 3
flx-i2c w 1:0:0x68  0x0001 0x03
# this is registers set on page 3
flx-i2c w 1:0:0x68  0x0002 0x00
flx-i2c w 1:0:0x68  0x0003 0x00
flx-i2c w 1:0:0x68  0x0004 0x00
flx-i2c w 1:0:0x68  0x0005 0x80
flx-i2c w 1:0:0x68  0x0006 0x0E
flx-i2c w 1:0:0x68  0x0007 0x00
flx-i2c w 1:0:0x68  0x0008 0x00
flx-i2c w 1:0:0x68  0x0009 0x00
flx-i2c w 1:0:0x68  0x000A 0x00
flx-i2c w 1:0:0x68  0x000B 0x80
flx-i2c w 1:0:0x68  0x000D 0x00
flx-i2c w 1:0:0x68  0x000E 0x00
flx-i2c w 1:0:0x68  0x000F 0x00
flx-i2c w 1:0:0x68  0x0010 0x00
flx-i2c w 1:0:0x68  0x0011 0x00
flx-i2c w 1:0:0x68  0x0012 0x00
flx-i2c w 1:0:0x68  0x0013 0x00
flx-i2c w 1:0:0x68  0x0014 0x00
flx-i2c w 1:0:0x68  0x0015 0x00
flx-i2c w 1:0:0x68  0x0016 0x00
flx-i2c w 1:0:0x68  0x0018 0x00
flx-i2c w 1:0:0x68  0x0019 0x00
flx-i2c w 1:0:0x68  0x001A 0x00
flx-i2c w 1:0:0x68  0x001B 0x00
flx-i2c w 1:0:0x68  0x001C 0x00
flx-i2c w 1:0:0x68  0x001D 0x00
flx-i2c w 1:0:0x68  0x001E 0x00
flx-i2c w 1:0:0x68  0x001F 0x00
flx-i2c w 1:0:0x68  0x0020 0x00
flx-i2c w 1:0:0x68  0x0021 0x00
flx-i2c w 1:0:0x68  0x0023 0x00
flx-i2c w 1:0:0x68  0x0024 0x00
flx-i2c w 1:0:0x68  0x0025 0x00
flx-i2c w 1:0:0x68  0x0026 0x00
flx-i2c w 1:0:0x68  0x0027 0x00
flx-i2c w 1:0:0x68  0x0028 0x00
flx-i2c w 1:0:0x68  0x0029 0x00
flx-i2c w 1:0:0x68  0x002A 0x00
flx-i2c w 1:0:0x68  0x002B 0x00
flx-i2c w 1:0:0x68  0x002C 0x00
flx-i2c w 1:0:0x68  0x002E 0x00
flx-i2c w 1:0:0x68  0x002F 0x00
flx-i2c w 1:0:0x68  0x0030 0x00
flx-i2c w 1:0:0x68  0x0031 0x00
flx-i2c w 1:0:0x68  0x0032 0x00
flx-i2c w 1:0:0x68  0x0033 0x00
flx-i2c w 1:0:0x68  0x0034 0x00
flx-i2c w 1:0:0x68  0x0035 0x00
flx-i2c w 1:0:0x68  0x0036 0x00
flx-i2c w 1:0:0x68  0x0037 0x00
flx-i2c w 1:0:0x68  0x0039 0x1F
flx-i2c w 1:0:0x68  0x003B 0x00
flx-i2c w 1:0:0x68  0x003C 0x00
flx-i2c w 1:0:0x68  0x003D 0x00
flx-i2c w 1:0:0x68  0x003E 0x00
flx-i2c w 1:0:0x68  0x003F 0x00
flx-i2c w 1:0:0x68  0x0040 0x00
flx-i2c w 1:0:0x68  0x0041 0x00
flx-i2c w 1:0:0x68  0x0042 0x00
flx-i2c w 1:0:0x68  0x0043 0x00
flx-i2c w 1:0:0x68  0x0044 0x00
flx-i2c w 1:0:0x68  0x0045 0x00
flx-i2c w 1:0:0x68  0x0046 0x00
flx-i2c w 1:0:0x68  0x0047 0x00
flx-i2c w 1:0:0x68  0x0048 0x00
flx-i2c w 1:0:0x68  0x0049 0x00
flx-i2c w 1:0:0x68  0x004A 0x00
flx-i2c w 1:0:0x68  0x004B 0x00
flx-i2c w 1:0:0x68  0x004C 0x00
flx-i2c w 1:0:0x68  0x004D 0x00
flx-i2c w 1:0:0x68  0x004E 0x00
flx-i2c w 1:0:0x68  0x004F 0x00
flx-i2c w 1:0:0x68  0x0050 0x00
flx-i2c w 1:0:0x68  0x0051 0x00
flx-i2c w 1:0:0x68  0x0052 0x00
flx-i2c w 1:0:0x68  0x0053 0x00
flx-i2c w 1:0:0x68  0x0054 0x00
flx-i2c w 1:0:0x68  0x0055 0x00
flx-i2c w 1:0:0x68  0x0056 0x00
flx-i2c w 1:0:0x68  0x0057 0x00
flx-i2c w 1:0:0x68  0x0058 0x00
flx-i2c w 1:0:0x68  0x0059 0x00
flx-i2c w 1:0:0x68  0x005A 0x00
flx-i2c w 1:0:0x68  0x005B 0x00
flx-i2c w 1:0:0x68  0x005C 0x00
flx-i2c w 1:0:0x68  0x005D 0x00
flx-i2c w 1:0:0x68  0x005E 0x00
flx-i2c w 1:0:0x68  0x005F 0x00
flx-i2c w 1:0:0x68  0x0060 0x00
flx-i2c w 1:0:0x68  0x0061 0x00
flx-i2c w 1:0:0x68  0x0062 0x00
#turn the page to 4
flx-i2c w 1:0:0x68  0x0001 0x04
# this is registers set on page 4
flx-i2c w 1:0:0x68  0x0087 0x01
#turn the page to 5
flx-i2c w 1:0:0x68  0x0001 0x05
# this is registers set on page 5
flx-i2c w 1:0:0x68  0x0002 0x01
flx-i2c w 1:0:0x68  0x0008 0x15
flx-i2c w 1:0:0x68  0x0009 0x27
flx-i2c w 1:0:0x68  0x000A 0x0A
flx-i2c w 1:0:0x68  0x000B 0x09
flx-i2c w 1:0:0x68  0x000C 0x0F
flx-i2c w 1:0:0x68  0x000D 0x3F
flx-i2c w 1:0:0x68  0x000E 0x16
flx-i2c w 1:0:0x68  0x000F 0x2B
flx-i2c w 1:0:0x68  0x0010 0x09
flx-i2c w 1:0:0x68  0x0011 0x08
flx-i2c w 1:0:0x68  0x0012 0x0F
flx-i2c w 1:0:0x68  0x0013 0x3F
flx-i2c w 1:0:0x68  0x0015 0x00
flx-i2c w 1:0:0x68  0x0016 0x00
flx-i2c w 1:0:0x68  0x0017 0x00
flx-i2c w 1:0:0x68  0x0018 0x00
flx-i2c w 1:0:0x68  0x0019 0x66
flx-i2c w 1:0:0x68  0x001A 0x03
flx-i2c w 1:0:0x68  0x001B 0x00
flx-i2c w 1:0:0x68  0x001C 0x00
flx-i2c w 1:0:0x68  0x001D 0x00
flx-i2c w 1:0:0x68  0x001E 0x00
flx-i2c w 1:0:0x68  0x001F 0x80
flx-i2c w 1:0:0x68  0x0021 0x21
flx-i2c w 1:0:0x68  0x002A 0x00
flx-i2c w 1:0:0x68  0x002B 0x01
flx-i2c w 1:0:0x68  0x002C 0x0F
flx-i2c w 1:0:0x68  0x002D 0x03
flx-i2c w 1:0:0x68  0x002E 0x19
flx-i2c w 1:0:0x68  0x002F 0x19
flx-i2c w 1:0:0x68  0x0031 0x00
flx-i2c w 1:0:0x68  0x0032 0x10
flx-i2c w 1:0:0x68  0x0033 0x04
flx-i2c w 1:0:0x68  0x0034 0x00
flx-i2c w 1:0:0x68  0x0036 0x0C
flx-i2c w 1:0:0x68  0x0037 0x00
flx-i2c w 1:0:0x68  0x0038 0x00
flx-i2c w 1:0:0x68  0x0039 0x00
#turn the page to 9
flx-i2c w 1:0:0x68  0x0001 0x09
# this is registers set on page 9
flx-i2c w 1:0:0x68  0x000E 0x02
flx-i2c w 1:0:0x68  0x0043 0x00
flx-i2c w 1:0:0x68  0x0049 0x0B
flx-i2c w 1:0:0x68  0x004A 0x0B
#turn the page to A
flx-i2c w 1:0:0x68  0x0001 0x0A
# this is registers set on page A
flx-i2c w 1:0:0x68  0x0002 0x00
flx-i2c w 1:0:0x68  0x0003 0x01
flx-i2c w 1:0:0x68  0x0004 0x01
flx-i2c w 1:0:0x68  0x0005 0x01
#turn the page to B
flx-i2c w 1:0:0x68  0x0001 0x0B
# this is registers set on page B
flx-i2c w 1:0:0x68  0x0044 0x2F
flx-i2c w 1:0:0x68  0x0046 0x00
flx-i2c w 1:0:0x68  0x0047 0x00
flx-i2c w 1:0:0x68  0x0048 0x04
flx-i2c w 1:0:0x68  0x004A 0x1E
# finish initialization procedure
sleep .5
flx-i2c w 1:0:0x68  0x0001 0x05
flx-i2c w 1:0:0x68  0x0014 0x01
sleep .5
flx-i2c w 1:0:0x68  0x0001 0x00
flx-i2c w 1:0:0x68  0x001C 0x01
sleep .5
flx-i2c w 1:0:0x68  0x0001 0x0B
sleep .5
flx-i2c w 1:0:0x68  0x0024 0xDB
flx-i2c w 1:0:0x68  0x0025 0x02

echo "configuration done ..."
echo "enabling output ..."
flx-config set HK_CTRL_FMC_SI5345_OE=0x00

echo "reading back a couple of registers"
#check if the register got messed up...
flx-i2c w 1:0:0x68  0x0001 0x00
#flx-i2c r 1:0:0x68 0x000B
echo "LOS register:"
flx-i2c r 1:0:0x68 0x000D
# sticky
flx-i2c r 1:0:0x68 0x0012
flx-i2c w 1:0:0x68 0x0012 0x0
flx-i2c r 1:0:0x68 0x0012

for i in `seq 1 60`;
do
	LOL=$(flx-i2c r 1:0:0x68 0x000E|grep Register)
	echo "LOL register: $LOL"

	if [[ $LOL == "Register 0x000E = 0x0" ]]
	then
		echo "Found lock in $i seconds"
		break
	fi
	sleep 1
done
#flx-i2c r 1:0:0x68 0x000E
# sticky
flx-i2c r 1:0:0x68 0x0013
flx-i2c w 1:0:0x68 0x0013 0x0
flx-i2c r 1:0:0x68 0x0013
# flx-i2c r 1:0:0x68 1
# flx-i2c r 1:0:0x68 2
# flx-i2c r 1:0:0x68 4
# flx-i2c r 1:0:0x68 5
# flx-i2c r 1:0:0x68 35
# flx-i2c r 1:0:0x68 36
