/*  =========================================================================
    zyre - ZYRE wrapper

    Copyright (c) 1991-2012 iMatix Corporation -- http://www.imatix.com     
    Copyright other contributors as noted in the AUTHORS file.              
                                                                            
    This file is part of Zyre, an open-source framework for proximity-based 
    peer-to-peer applications -- See http://zyre.org.                       
                                                                            
    This is free software; you can redistribute it and/or modify it under   
    the terms of the GNU Lesser General Public License as published by the  
    Free Software Foundation; either version 3 of the License, or (at your  
    option) any later version.                                              
                                                                            
    This software is distributed in the hope that it will be useful, but    
    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTA-   
    BILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General  
    Public License for more details.                                        
                                                                            
    You should have received a copy of the GNU Lesser General Public License
    along with this program. If not, see http://www.gnu.org/licenses/.      

################################################################################
#  THIS FILE IS 100% GENERATED BY ZPROJECT; DO NOT EDIT EXCEPT EXPERIMENTALLY  #
#  Please refer to the README for information about making permanent changes.  #
################################################################################
    =========================================================================
*/

#ifndef zyre_library_H_INCLUDED
#define zyre_library_H_INCLUDED

//  Set up environment for the application

//  External dependencies
#include <czmq.h>

//  ZYRE version macros for compile-time API detection

#define ZYRE_VERSION_MAJOR 1
#define ZYRE_VERSION_MINOR 1
#define ZYRE_VERSION_PATCH 0

#define ZYRE_MAKE_VERSION(major, minor, patch) \
    ((major) * 10000 + (minor) * 100 + (patch))
#define ZYRE_VERSION \
    ZYRE_MAKE_VERSION(ZYRE_VERSION_MAJOR, ZYRE_VERSION_MINOR, ZYRE_VERSION_PATCH)

#if defined (__WINDOWS__)
#   if defined LIBZYRE_STATIC
#       define ZYRE_EXPORT
#   elif defined LIBZYRE_EXPORTS
#       define ZYRE_EXPORT __declspec(dllexport)
#   else
#       define ZYRE_EXPORT __declspec(dllimport)
#   endif
#else
#   define ZYRE_EXPORT
#endif

//  Opaque class structures to allow forward references
typedef struct _zyre_t zyre_t;
#define ZYRE_T_DEFINED
typedef struct _zyre_event_t zyre_event_t;
#define ZYRE_EVENT_T_DEFINED
typedef struct _zre_msg_t zre_msg_t;
#define ZRE_MSG_T_DEFINED

//  Public constants
#define ZRE_DISCOVERY_PORT	5670 //              IANA-assigned UDP port for ZRE

//  Public API classes
#include "zyre_event.h"
#include "zre_msg.h"

#endif
/*
################################################################################
#  THIS FILE IS 100% GENERATED BY ZPROJECT; DO NOT EDIT EXCEPT EXPERIMENTALLY  #
#  Please refer to the README for information about making permanent changes.  #
################################################################################
*/
