#ifndef FELIXSERVER_UTILITY_HPP
#define FELIXSERVER_UTILITY_HPP

#include <netio3-backend/Netio3Backend.hpp>

namespace felix_server::utility {
  [[nodiscard]] inline netio3::NetworkMode get_network_mode(netio3::NetworkType type)
  {
    switch (type) {
    case netio3::NetworkType::LIBFABRIC:
      return netio3::NetworkMode::RDMA;
    case netio3::NetworkType::ASYNCMSG:
      return netio3::NetworkMode::TCP;
    default:
      throw std::logic_error("Invalid NetworkType");
    }
  }

}  // namespace felix_server

#endif  // FELIXSERVER_UTILITY_HPP
