#ifndef FELIXCLIENT_ISSUES_HPP
#define FELIXCLIENT_ISSUES_HPP

#include <cstdint>
#include <format>
#include <sstream>
#include <vector>

#include <ers/ers.h>

#include "felix/FelixClientUtility.hpp"

struct ErsVectorWrapper {
  inline friend std::ostringstream& operator<<(std::ostringstream& os,
                                               const ErsVectorWrapper& vec)
  {
    for (size_t i = 0; i < vec.data.size(); ++i) {
      if (i != 0) {
        os << " ";  // Delimiter
      }
      os << vec.data.at(i);
    }
    return os;
  }
  inline friend std::istringstream& operator>>(std::istringstream& is,
                                               ErsVectorWrapper& vec)
  {
    vec.data.clear();
    std::uint64_t value{};
    while (is >> value) {
      vec.data.push_back(value);
    }
    return is;
  }

  std::vector<std::uint64_t> data;
};

ERS_DECLARE_ISSUE(felix,
                  InvalidIp,
                  std::format("Could not deduce the local ip address from {}",
                              local_ip_or_interface),
                  ((const std::string&)local_ip_or_interface))
ERS_DECLARE_ISSUE(felix,
                  FailedSettingCpuAffinity,
                  std::format("Setting affinity to CPU rage [{}] failed with error {}",
                              affinity,
                              error),
                  ((const std::string&)affinity)((int)error))
ERS_DECLARE_ISSUE(felix,
                  FelixBusError,
                  std::format("Error while reading bus: {}", error),
                  ((const std::string&)error))
ERS_DECLARE_ISSUE(felix,
                  SubscriptionTimeoutError,
                  std::format("Subscribing to {} failed because operation timed out", fids),
                  ((const std::string&)fids))
ERS_DECLARE_ISSUE(
  felix,
  SubscriptionFailedError,
  std::format("Subscribing to {} failed", utility::fids_to_string(fids_bad.data)),
  ((const ErsVectorWrapper&)fids_success)((const ErsVectorWrapper&)fids_bad)((
    const ErsVectorWrapper&)fids_failed)((const ErsVectorWrapper&)fids_timeout))
ERS_DECLARE_ISSUE(
  felix,
  AsyncSubscriptionFailedError,
  std::format("Ansychrnous subscription to {} failed", utility::fids_to_string(fids_bad.data)),
  ((const ErsVectorWrapper&)fids_bad))
ERS_DECLARE_ISSUE(felix,
                  UnsubscriptionFailedError,
                  std::format("Unsubscribing from {} failed", utility::fids_to_string(fids_bad.data)),
  ((const ErsVectorWrapper&)fids_success)((const ErsVectorWrapper&)fids_bad)((
    const ErsVectorWrapper&)fids_failed)((const ErsVectorWrapper&)fids_timeout))
ERS_DECLARE_ISSUE(
  felix,
  AsyncUnsubscriptionFailedError,
  std::format("Ansychrnous unsubscription from {} failed", utility::fids_to_string(fids_bad.data)),
  ((const ErsVectorWrapper&)fids_bad))
ERS_DECLARE_ISSUE(felix,
                  UnsubscriptionError,
                  std::format("Unsubscribing from {} failed because of: {}", fids, error),
                  ((const std::string&)fids)((const std::string&)error))
ERS_DECLARE_ISSUE(felix,
                  SubscriptionAlreadyDoneError,
                  std::format("Subscribing to {} failed because already subscribed", fids),
                  ((const std::string&)fids))
ERS_DECLARE_ISSUE(felix,
                  FailedClosingConnections,
                  std::format("Timeout during stopping netio, not all subscriptions have been "
                              "closed. {} subscriptions remain open",
                              num),
                  ((std::size_t)num))
ERS_DECLARE_ISSUE(felix,
                  SendConnectionRefused,
                  std::format("Connection to {:#x} has been refused", tag),
                  ((std::uint64_t)tag))
ERS_DECLARE_ISSUE(felix,
                  SendConnectionTimedOut,
                  std::format("Connection to {:#x} has timed out", tag),
                  ((std::uint64_t)tag))
ERS_DECLARE_ISSUE(felix,
                  SendDisconnectionTimedOut,
                  std::format("Closing connection to {:#x} has timed out", tag),
                  ((std::uint64_t)tag))
ERS_DECLARE_ISSUE(felix, SendDisconnectionAllTimedOut, "Closing all connection has timed out", )  // cppcheck-suppress syntaxError
ERS_DECLARE_ISSUE(felix,
                  UnknownSendConnection,
                  std::format("No send connection to {}:{}", address, port),
                  ((const std::string&)address)((std::uint16_t)port))
ERS_DECLARE_ISSUE(
  felix,
  SendWithoutInitDeprecated,
  std::format("Sending data without establishing connection beforehand is deprecated (tag: {:#x})",
              tag),
  ((std::uint64_t)tag))
ERS_DECLARE_ISSUE(felix,
                  SendBeforeConnected,
                  std::format("Cannot send data if connection is not established (tag: {:#x})", tag),
                  ((std::uint64_t)tag))
ERS_DECLARE_ISSUE(felix,
                  SendDuringReconnect,
                  std::format("Cannot send data while a connection is down (tag: {:#x})", tag),
                  ((std::uint64_t)tag))
ERS_DECLARE_ISSUE(
  felix,
  RegisterBusError,
  std::format("Discarding ctrl fid {:#x} because reply fid {:#x} does not appear in the bus",
              ctrl_fid,
              sub_fid),
  ((std::uint64_t)ctrl_fid)((std::uint64_t)sub_fid))
ERS_DECLARE_ISSUE(felix, GetIfAddrsProblem, "getifaddrs problem", )
ERS_DECLARE_ISSUE(
  felix,
  DeprecatedProperty,
  std::format("Configuration property '{}' is deprecated", name),
  ((const std::string&)name))
ERS_DECLARE_ISSUE(
  felix,
  DeprecatedFunctionCall,
  std::format("Calling '{}' is deprecated", name),
  ((const std::string&)name))
ERS_DECLARE_ISSUE(
  felix,
  ExecTriggeredWithoutCallback,
  "Exec triggered without callback being in queue",
)
ERS_DECLARE_ISSUE(felix,
                  InvalidBlock,
                  std::format("Received invalid block (reason: {}). Dropping", reason),
                  ((const std::string&)reason))

#endif  // FELIXCLIENT_ISSUES_HPP