#ifndef FELIXCLIENT_NETIO3BUSINTERFACE_HPP
#define FELIXCLIENT_NETIO3BUSINTERFACE_HPP

#include <netio3-backend/Netio3Backend.hpp>

namespace internal {
  enum class ConnectionType { tcp, rdma };

  /**
   * @brief Helper class to convert the connection type from bus to the netio3 network type and mode
   */
  class Netio3BusInterface
  {
  public:
    /**
     * @brief Get the netio3 network type for a given connection type
     *
     * ASYNCMSG for TCP, LIBFABRIC for RDMA
     *
     * @throws std::logic_error if the connection type is unknown
     * @param connection_type Connection type
     * @return netio3 network type
     */
    [[nodiscard]] static netio3::NetworkType get_network_type(ConnectionType connection_type);

    /**
     * @brief Get the netio3 network mode for a given connection type
     *
     * @throws std::logic_error if the connection type is unknown
     * @param connection_type Connection type
     * @return netio3 network mode
     */
    [[nodiscard]] static netio3::NetworkMode get_network_mode(ConnectionType connection_type);
  };
}  // namespace internal

#endif  // FELIXCLIENT_NETIO3BUSINTERFACE_HPP