#ifndef FELIXCLIENT_SETTINGS_HPP
#define FELIXCLIENT_SETTINGS_HPP

#include <set>
#include <string>

#include <netio3-backend/Netio3Backend.hpp>

/**
 * @brief Enum class for the event loop type
 */
enum class EventLoopType {
    netio3_native,
    netio3_asio
};


/**
 * @brief Struct for the bus settings
 */
struct BusSettings {
    std::string bus_dir{"./bus"};
    std::string bus_group_name{"FELIX"};
    bool verbose_bus{false};
};

/**
 * @brief Struct for the Felix client callbacks
 */
struct FelixClientCallbackSettings {
    std::function<void()> on_init{nullptr};
    std::function<void(uint64_t, std::span<const uint8_t>, uint8_t)> on_msg_received{nullptr};
    std::function<void(std::span<const std::uint8_t>)> on_buffer_received{nullptr};
    std::function<void(uint64_t)> on_connection_established{nullptr};
    std::function<void(uint64_t)> on_connection_closed{nullptr};
    std::function<void(uint64_t)> on_connection_refused{nullptr};
    std::function<void(const std::set<uint64_t>&)> on_subscriptions_lost{nullptr};
    std::function<void(uint64_t)> on_resubscription{nullptr};
};

/**
 * @brief Struct for the Felix client settings
 *
 * Bus settings and event loop type
 */
struct FelixClientSettings {
    BusSettings bus_settings;
    FelixClientCallbackSettings callbacks;
    EventLoopType eventloop_type{EventLoopType::netio3_native};
    netio3::ThreadSafetyModel thread_safety_model{netio3::ThreadSafetyModel::SAFE};
};

#endif  // FELIXCLIENT_SETTINGS_HPP