#ifndef FELIXCLIENT_FELIXCLIENTTHREADIMPL_HPP
#define FELIXCLIENT_FELIXCLIENTTHREADIMPL_HPP

#include <string>

#include <felix/felix_client_thread_interface.hpp>
#include <felix/felix_client_thread_extension.hpp>
#include <felix/felix_client_thread_extension520.hpp>

#include "felix/felix_client.hpp"

/**
 * @brief FelixClientThreadImpl is the implementation of felix-interface
 *
 * This class is a wrapper around the felix-client object. The felix-client object is created in the
 * constructor using the config properties and callbacks set in the config argument. It also starts
 * the event loop. The desctructor stops the event loop and joins the event loop thread.
 *
 * Check the documentation of felix-interface for a description of the functions.
 */
class FelixClientThreadImpl : public FelixClientThreadExtension520 {

public:
        /**
         * @brief Construct a new FelixClientThreadImpl object
         *
         * The constructor creates a new FelixClient object and starts the event loop.
         *
         * @param config The configuration object containing settings and callbacks
         */
	explicit FelixClientThreadImpl(const ConfigV2& config);

        [[deprecated("Use FelixClientThreadImpl(ConfigV2&) instead")]]
	explicit FelixClientThreadImpl(Config& config);

        /**
         * @brief Destroy the FelixClientThreadImpl object
         *
         * The destructor stops the event loop and joins the event loop thread.
         */
        ~FelixClientThreadImpl();

	void send_data(uint64_t fid, std::span<const uint8_t> data, bool flush) override;
        [[deprecated("Use send_data(uint64_t, std::span<const uint8_t>, bool) instead")]]
	void send_data(uint64_t fid, const uint8_t* data, size_t size, bool flush) override;
        [[deprecated("Use send_data(netio_tag_t, const std::vector<std::span<const uint8_t>>&) instead")]]
        void send_data(netio_tag_t fid, const std::vector<const uint8_t*>& msgs, const std::vector<size_t>& sizes) override;
        void send_data(netio_tag_t fid, const std::vector<std::span<const uint8_t>>& msgs) override;

        [[deprecated("Use send_data instead")]]
        void send_data_nb(uint64_t fid, const uint8_t* data, size_t size, bool flush) override;
        [[deprecated("Use send_data instead")]]
        void send_data_nb(netio_tag_t fid, const std::vector<const uint8_t*>& msgs, const std::vector<size_t>& sizes) override;

        [[deprecated("Use subscribe(uint64_t, std::chrono::milliseconds) or subscribe_nb(uint64_t) instead")]]
	void subscribe(uint64_t fid) override;
        [[deprecated("Use subscribe(const std::vector<uint64_t>&, std::chrono::milliseconds) or subscribe_nb(const std::vector<uint64_t>&) instead")]]
        void subscribe(const std::vector<uint64_t>& fids) override;
        void subscribe(std::uint64_t fid, std::chrono::milliseconds timeout) override;
        void subscribe(const std::vector<uint64_t>& fids, std::chrono::milliseconds timeout) override;
        void subscribe_nb(std::uint64_t fid) override;
        void subscribe_nb(const std::vector<uint64_t>& fids) override;
        [[deprecated("Use unsubscribe(const uint64_t, std::chrono::milliseconds) or subscribe_nb(const uint64_t) instead")]]
	void unsubscribe(uint64_t fid) override;
        void unsubscribe_nb(std::uint64_t fid) override;
        void unsubscribe(std::uint64_t fid, std::chrono::milliseconds timeout) override;

	void exec(const UserFunction &user_function) override;

        [[deprecated("Use init_send_data(uint64_t, std::chrono::milliseconds) or init_send_data_nb(uint64_t) instead")]]
        void init_send_data(uint64_t fid) override;
        void init_send_data(uint64_t fid, std::chrono::milliseconds timeout) override;
        void init_send_data_nb(uint64_t fid) override;
        [[deprecated("init_subscribe no longer needed")]]
        void init_subscribe(uint64_t fid) override;

        Status send_cmd(const std::vector<uint64_t>& fids, Cmd cmd, const std::vector<std::string>& cmd_args, std::vector<Reply>& replies) override;

        [[deprecated("Use user_timer_start(std::chrono::milliseconds) instead")]]
        void user_timer_start(unsigned long interval) override;
        void user_timer_start(std::chrono::milliseconds interval) override;
        void user_timer_stop() override;
        void callback_on_user_timer(OnUserTimerCallback on_user_timer_cb) override;

        [[nodiscard]] std::map<std::uint64_t, std::size_t> get_available_send_buffers() override;
        [[nodiscard]] std::map<std::uint64_t, FelixClientThread::BlockDecoderStats> get_block_decoder_stats() const override;

        void create_trickle_config() override;
        void append_trickle_config(const std::uint64_t fid, const std::vector<uint8_t>& payload) override;
        void send_trickle_config(std::uint64_t fid) override;
        void start_trickle(std::uint64_t fid) override;
        void stop_trickle(std::uint64_t fid) override;
        void select_trickle_bcids(std::uint64_t fid, std::uint32_t first_bcid, std::uint32_t last_bcid) override;
        void throttle_trickle(std::uint64_t fid, std::uint32_t throttle_factor) override;

private:
    std::unique_ptr<FelixClient> m_client;
    std::thread m_thread;

    uint m_timeoutms;
};

#endif //FELIXCLIENT_FELIXCLIENTTHREADIMPL_HPP