#ifndef I2CDEVICES_H
#define I2CDEVICES_H

// I2C definitions
#define I2C_ADDR_SWITCH1_FLX_711          0x70
#define I2C_ADDR_SWITCH1_FLX_710          0x70
#define I2C_ADDR_SWITCH1_FLX_709          0x74
#define I2C_ADDR_SWITCH2_FLX_709          0x75
#define I2C_ADDR_SWITCH1_FLX_128          0x74
#define I2C_ADDR_SWITCH2_FLX_128          0x75
#define I2C_ADDR_SWITCH3_FLX_128          0x76
#define I2C_ADDR_SWITCH1_FLX_182          0x77
#define I2C_ADDR_SWITCH1_FLX_155          0x77
#define I2C_FULL_FLAG                     (1 << 25)
#define I2C_EMPTY_FLAG                    (1 << 8)
#define I2C_DELAY                         1000
#define I2C_SLEEP                         100

// I2C error codes
#define I2C_DEVICE_ERROR_NOT_EXISTING     1
#define I2C_DEVICE_ERROR_INVALID_PORT     2
#define I2C_DEVICE_ERROR_INVALID_ADDRESS  3
#define I2C_DEVICE_ERROR_INVALID_REGISTER 4
#define I2C_DEVICE_ERROR_INVALID_DATA     5

typedef struct i2c_device
{
  const char *name;
  const char *description;
  u_char      address;
  u_char      i2c_switch_val[3];
} i2c_device_t;

// NB: don't use '-' in i2c_device_t member 'name' (first parameter):
//     gets mapped to '_'; change to using only '-' and map '_' to '-'? (Henk)

const i2c_device_t i2c_devices_FLX_709[] =
  {
    {"USR_CLK",         "SI570",                    0x5D, {  1,0,0} },
    {"ADN2814",         "ADN2814",                  0x40, {  2,0,0} },
    {"SI5345",          "SI5345",                   0x68, {  2,0,0} },
    {"FMC_TEMP_SENSOR", "TC74 (on CRORC TEST FMC)", 0x4A, {  2,0,0} },
    {"ID_EEPROM",       "M24C08-WDW6TP",            0x54, {  8,0,0} },
    {"SFP1_1",          "AFBR-709SMZ (Conven Mem)", 0x50, { 16,1,0} },
    {"SFP1_2",          "AFBR-709SMZ (Enhan Mem)",  0x51, { 16,1,0} },
    {"SFP2_1",          "AFBR-709SMZ (Conven Mem)", 0x50, { 16,2,0} },
    {"SFP2_2",          "AFBR-709SMZ (Enhan Mem)",  0x51, { 16,2,0} },
    {"SFP3_1",          "AFBR-709SMZ (Conven Mem)", 0x50, { 16,4,0} },
    {"SFP3_2",          "AFBR-709SMZ (Enhan Mem)",  0x51, { 16,4,0} },
    {"SFP4_1",          "AFBR-709SMZ (Conven Mem)", 0x50, { 16,8,0} },
    {"SFP4_2",          "AFBR-709SMZ (Enhan Mem)",  0x51, { 16,8,0} },
    {"DDR3_1",          "SRAM-MT8KTF51264HZ",       0x51, { 64,0,0} },
    {"DDR3_2",          "SRAM-MT8KTF51264HZ",       0x52, { 64,0,0} },
    {"SI5324",          "SI5324",                   0x68, {128,0,0} },
    {NULL,              NULL,                       0,    {  0,0,0} }
  };

const i2c_device_t i2c_devices_FLX_710[] =
  {
    {"CLOCK_RAM",       "ICS8N4Q001L IDT",          0x6E, {  1,0,0} },
    {"CLOCK_SYS",       "ICS8N4Q001L IDT",          0x6E, {  2,0,0} },
    {"CLOCK_CXP1",      "IDT 8N3Q001",              0x6E, {  4,0,0} },
    {"CLOCK_CXP2",      "IDT 8N3Q001",              0x6E, {  8,0,0} },
    {"ADN2814",         "ADN2814 (on TTCfx FMC)",   0x40, { 16,0,0} },
    {"SI5345",          "SI5345",                   0x68, { 16,0,0} },
    {"FMC_TEMP_SENSOR", "TC74 (on CRORC TEST FMC)", 0x4A, { 16,0,0} },
    {"CXP1_TX",         "AFBR-83PDZ",               0x50, { 32,0,0} },
    {"CXP1_RX",         "AFBR-83PDZ",               0x54, { 32,0,0} },
    {"CXP2_TX",         "AFBR-83PDZ",               0x50, { 64,0,0} },
    {"CXP2_RX",         "AFBR-83PDZ",               0x54, { 64,0,0} },
    {"DDR3_1",          "SRAM-MT16JTF25664HZ",      0x50, {128,0,0} },
    {"DDR3_2",          "SRAM-MT16JTF25664HZ",      0x51, {128,0,0} },
    {NULL,              NULL,                       0,    {  0,0,0} }
  };

const i2c_device_t i2c_devices_FLX_711[] =
  {
    {"ADN2814",         "ADN2814",                  0x40, {2,0,0} },
    {"SIS53154",        "SI53154",                  0x6B, {2,0,0} },
    {"LTC2991_1",       "LTC2991",                  0x48, {2,0,0} },
    {"LTC2991_2",       "LTC2991",                  0x49, {2,0,0} },
    {"SI5345",          "SI5345",                   0x68, {4,0,0} },
    {"IO_EXPANDER",     "TCA6408A",                 0x20, {4,0,0} },
    {"1ST TX",          "MiniPOD AFBR-814",         0x2C, {8,0,0} },
    {"2ND TX",          "MiniPOD AFBR-814",         0x2D, {8,0,0} },
    {"3RD TX",          "MiniPOD AFBR-814",         0x2E, {8,0,0} },
    {"4TH TX",          "MiniPOD AFBR-814",         0x2F, {8,0,0} },
    {"1ST RX",          "MiniPOD AFBR-824",         0x30, {8,0,0} },
    {"2ND RX",          "MiniPOD AFBR-824",         0x31, {8,0,0} },
    {"3RD RX",          "MiniPOD AFBR-824",         0x32, {8,0,0} },
    {"4TH RX",          "MiniPOD AFBR-824",         0x33, {8,0,0} },
    {NULL,              NULL,                       0,    {0,0,0} }
  };

const int MINIPOD_CNT = 8;
// RXes followed by TXes
const char *POD_NAMES[] = { "1st RX", "2nd RX", "3rd RX", "4th RX",
                            "1st TX", "2nd TX", "3rd TX", "4th TX" };
// Each RX followed by TX, alternating
//const char *POD_NAMES[] = { "1st TX", "1st RX", "2nd TX", "2nd RX",
//                            "3rd TX", "3rd RX", "4th TX", "4th RX" };
const char *LTC_NAMES[] = { "LTC2991-1", "LTC2991-2" };

const i2c_device_t i2c_devices_FLX_128[] =
  {
    {"IO_EXPANDER",         "TCA6416A",             0x20, { 0,0,0} },
    {"PMBUS_VCCINT",        "INA226",               0x40, { 0,1,0} },
    {"PMBUS_VCCBRAM",       "INA226",               0x41, { 0,1,0} },
    {"PMBUS_VCCVCC1V8",     "INA226",               0x42, { 0,1,0} },
    {"PMBUS_MGTAVCC",       "INA226",               0x46, { 0,1,0} },
    {"PMBUS_MGTAVTT",       "INA226",               0x47, { 0,1,0} },
    {"PMBUS_MGTAVCC",       "INA226",               0x48, { 0,1,0} },
    {"PMBUS_VCCHBM",        "INA226",               0x4C, { 0,1,0} },
    {"PMBUS_VCCAUX_HBM",    "INA226",               0x4D, { 0,1,0} },
    {"MAIN_PMBUS_SYS1V8",   "ISL91211",             0x60, { 0,4,0} },
    {"MAIN_PMBUS_UTIL_1V35","ISL91302",             0x61, { 0,4,0} },
    {"MAIN_PMBUS_QDR_1V3",  "ISL91302",             0x62, { 0,4,0} },
    {"MAIN_PMBUS_VCC_VADJ", "ISL91302",             0x63, { 0,4,0} },
    {"MAIN_PMBUS_VDDQ",     "ISL91302",             0x64, { 0,4,0} },
    {"MAIN_PMBUS_VCCINT",   "ISL68127",             0x65, { 0,4,0} },
    {"MAIN_PMBUS_VCCHBM",   "ISL68301",             0x68, { 0,4,0} },
    {"MAIN_PMBUS_MGTAVTT",  "ISL68301",             0x69, { 0,4,0} },
    {"MAIN_PMBUS_UTIL_3V3", "ISL68301",             0x6A, { 0,4,0} },
    {"MAIN_PMBUS_UTIL_5V0", "ISL68301",             0x6B, { 0,4,0} },
    {"IIC_EEPROM",          "M24C08",               0x54, { 1,0,0} },
    {"SI5328",              "SI5328",               0x68, { 2,0,0} },
    {"QSFP1_SI570",         "SI570",                0x5D, { 8,0,0} },
    {"QSFP2_SI570",         "SI570",                0x5D, {16,0,0} },
    {"QSFP3_SI570",         "SI570",                0x5D, {32,0,0} },
    {"QSFP4_SI570",         "SI570",                0x5D, {64,0,0} },
    {"QSFP1_I2C",           "QSFP",                 0x50, { 0,0,16} },
    {"QSFP2_I2C",           "QSFP",                 0x50, { 0,0,32} },
    {"QSFP3_I2C",           "QSFP",                 0x50, { 0,0,64} },
    {"QSFP4_I2C",           "QSFP",                 0x50, { 0,0,128} },
    {NULL,                  NULL,                   0,    { 0,0,0} }
  };

const i2c_device_t i2c_devices_FLX_182[] =
  {
    {"POWER_SEQ_A_1066",    "ADM1066",              0x34, { 4,0,0} },
    {"POWER_SEQ_B_1066",    "ADM1066",              0x35, { 4,0,0} },
    {"POWER_SEQ_1266",      "ADM1266",              0x40, { 4,0,0} },
    {"POWER_GEN",           "LTM4700",              0x4E, { 1,0,0} },

    {"POWER_12P0V",         "INA226",               0x40, { 1,0,0} },
    {"POWER_VCCINT",        "INA226",               0x41, { 1,0,0} },
    {"POWER_MGTAVCC",       "INA226",               0x42, { 1,0,0} },
    {"POWER_MGTAVTT",       "INA226",               0x43, { 1,0,0} },
    {"POWER_SYS12",         "INA226",               0x44, { 1,0,0} },
    {"POWER_SYS15",         "INA226",               0x45, { 1,0,0} },
    {"POWER_SYS18",         "INA226",               0x46, { 1,0,0} },
    {"POWER_SYS25",         "INA226",               0x47, { 1,0,0} },
    {"POWER_SYS33",         "INA226",               0x48, { 1,0,0} },
    {"POWER_SYS38",         "INA226",               0x49, { 1,0,0} },

    {"TEMP_MGTAVCC",        "TMP435",               0x48, { 2,0,0} },
    {"TEMP_MGTAVTT",        "TMP435",               0x49, { 2,0,0} },
    {"TEMP_SYS12",          "TMP435",               0x4A, { 2,0,0} },
    {"TEMP_SYS15",          "TMP435",               0x4B, { 2,0,0} },
    {"TEMP_SYS18",          "TMP435",               0x4C, { 2,0,0} },
    {"TEMP_SYS33",          "TMP435",               0x4D, { 2,0,0} },
    {"TEMP_LTM4642",        "TMP435",               0x4E, { 2,0,0} },

    {"SI570_200MHZ_SYS",    "SI570",                0x60, { 4,0,0} },
    {"SI570_40MHZ_5345A",   "SI570",                0x60, { 8,0,0} },
    {"SI570_100MHZ_SYS",    "SI570",                0x55, { 8,0,0} },
    {"SI570_40MHZ_5345B",   "SI570",                0x60, { 16,0,0} },
    {"SI570_240MHZ_LTI",    "SI570",                0x60, { 32,0,0} },
    {"SI570_322MHZ_100GBE", "SI570",                0x60, { 64,0,0} },
    {"SI570_30MHZ_VERSAL",  "SI570",                0x5D, { 128,0,0} },

    {"SI5345A",             "SI5345",               0x68, { 128,0,0} },
    {"SI5345B",             "SI5345",               0x69, { 128,0,0} },
    {"SI5345A_BETA",        "SI5345",               0x7C, { 128,0,0} },
    {"SI5345B_BETA",        "SI5345",               0x7D, { 128,0,0} },

    {"IO_EXPANDER_A",       "TCA6424",              0x22, { 128,0,0} },
    {"IO_EXPANDER_B",       "TCA6424",              0x23, { 128,0,0} },

    {"FIREFLY_TX1",         "FIREFLY-TX",           0x50, { 16,0,0} },
    {"FIREFLY_RX1",         "FIREFLY-RX",           0x54, { 16,0,0} },
    {"FIREFLY_TX2",         "FIREFLY-TX",           0x50, { 32,0,0} },
    {"FIREFLY_RX2",         "FIREFLY-RX",           0x54, { 32,0,0} },
    {"FIREFLY_TXRX",        "FIREFLY-TXRX",         0x50, { 64,0,0} },
    {NULL,                  NULL,                   0,    { 0,0,0} }
  };

const std::vector<std::string> INA226_NAMES_182 = { "POWER_12P0V",   "POWER_VCCINT",
                                                    "POWER_MGTAVCC", "POWER_MGTAVTT",
                                                    "POWER_SYS12",   "POWER_SYS15",
                                                    "POWER_SYS18",   "POWER_SYS25",
                                                    "POWER_SYS33",   "POWER_SYS38" };
const float INA226_RSHUNT_182[] = { 1.5, 0.25, 1.0, 1.0, 1.0,
                                    1.0, 1.0, 1.0,  1.0, 1.0 };

const std::vector<std::string> TMP435_NAMES_182 = { "TEMP_MGTAVCC", "TEMP_MGTAVTT",
                                                    "TEMP_SYS12",   "TEMP_SYS15",
                                                    "TEMP_SYS18",   "TEMP_SYS33",
                                                    "TEMP_LTM4642" };

const std::vector<std::string> ADM1066_NAMES_182 = { "POWER_SEQ_A_1066", "POWER_SEQ_B_1066" };
const std::vector<std::string> ADM1266_NAMES_182 = { "POWER_SEQ_1266" };

const std::vector<std::string> FF_NAMES_TX_182   = { "FIREFLY_TX1", "FIREFLY_TX2" };
const std::vector<std::string> FF_NAMES_RX_182   = { "FIREFLY_RX1", "FIREFLY_RX2" };
const std::vector<std::string> FF_NAMES_TXRX_182 = { "FIREFLY_TXRX" };
const std::vector<std::string> FF_NAMES_182      = { "FIREFLY_TX1", "FIREFLY_RX1",
                                                     "FIREFLY_TX2", "FIREFLY_RX2",
                                                     "FIREFLY_TXRX" };

const i2c_device_t i2c_devices_FLX_155[] =
  {
    {"POWER_SEQ",           "ADM1266",              0x40, { 0x01,0,0} },
    {"POWER_GEN",           "LTM4700",              0x4E, { 0x02,0,0} },

    {"POWER_12P0V",         "INA226",               0x40, { 0x04,0,0} },
    {"POWER_VCCINT",        "INA226",               0x41, { 0x04,0,0} },
    {"POWER_MGTAVCC",       "INA226",               0x42, { 0x04,0,0} },
    {"POWER_MGTAVTT",       "INA226",               0x43, { 0x04,0,0} },
    {"POWER_VCC1V2",        "INA226",               0x44, { 0x08,0,0} },
    {"POWER_VCC1V5",        "INA226",               0x45, { 0x08,0,0} },
    {"POWER_VCC1V8",        "INA226",               0x46, { 0x08,0,0} },
    {"POWER_VCC2V5",        "INA226",               0x47, { 0x10,0,0} },
    {"POWER_VCC3V3",        "INA226",               0x48, { 0x10,0,0} },
    {"POWER_VCC3V8",        "INA226",               0x49, { 0x10,0,0} },
    {"POWER_VCC0V88",       "INA226",               0x4A, { 0x10,0,0} },

    {"TEMP_MGTAVCC",        "TMP435",               0x48, { 0x20,0,0} },
    {"TEMP_MGTAVTT",        "TMP435",               0x49, { 0x20,0,0} },
    {"TEMP_MGTAVTT2",       "TMP435",               0x4A, { 0x20,0,0} },
    {"TEMP_VCC1V5",         "TMP435",               0x4B, { 0x20,0,0} },
    {"TEMP_VCC1V8",         "TMP435",               0x4C, { 0x40,0,0} },
    {"TEMP_VCC3V3",         "TMP435",               0x4D, { 0x40,0,0} },
    {"TEMP_VCC2V5_3V8",     "TMP435",               0x4E, { 0x40,0,0} },
    {"TEMP_VCC0V88",        "TMP435",               0x4F, { 0x40,0,0} },

    {"IO_EXPANDER_A",       "TCA6424",              0x20, { 0x80,0,0} },
    {"IO_EXPANDER_B",       "TCA6424",              0x21, { 0x80,0,0} },

    {"FIREFLY1_TX",         "FIREFLY-TX",           0x50, { 0x04,0,0} },
    {"FIREFLY1_RX",         "FIREFLY-RX",           0x54, { 0x04,0,0} },
    {"FIREFLY2_TX",         "FIREFLY-TX",           0x50, { 0x08,0,0} },
    {"FIREFLY2_RX",         "FIREFLY-RX",           0x54, { 0x08,0,0} },
    {"FIREFLY3_TX",         "FIREFLY-TX",           0x50, { 0x10,0,0} },
    {"FIREFLY3_RX",         "FIREFLY-RX",           0x54, { 0x10,0,0} },
    {"FIREFLY4_TX",         "FIREFLY-TX",           0x50, { 0x20,0,0} },
    {"FIREFLY4_RX",         "FIREFLY-RX",           0x54, { 0x20,0,0} },
    {"FIREFLY5_TXRX",       "FIREFLY-TXRX",         0x50, { 0x40,0,0} },
    {"FIREFLY6_TXRX",       "FIREFLY-TXRX",         0x50, { 0x80,0,0} },

    {"SI570_30M_VERSAL",    "SI570",                0x5D, { 0x80,0,0} },
    {"SI570_200M_SYS",      "SI570",                0x60, { 0x80,0,0} },
    {"SI570_156M25_1",      "SI570",                0x60, { 0x04,0,0} },
    {"SI570_156M25_2",      "SI570",                0x60, { 0x08,0,0} },
    {"SI570_240M_TTC_REF",  "SI570",                0x60, { 0x10,0,0} },
    {"SI570_322M_100G_REF", "SI570",                0x60, { 0x10,0,0} },

    {"SI569_OSC_WR_1",      "SI569",                0x55, { 0x40,0,0} },
    {"SI569_OSC_WR_2",      "SI569",                0x55, { 0x80,0,0} },

    {"SI53X5_A",            "SI5345/SI5395",        0x68, { 0x40,0,0} },
    {"SI53X5_B",            "SI5345/SI5395",        0x69, { 0x80,0,0} },

    {"DDR4_MINIDIMM",       "DDR4",                 0x53, { 0x80,0,0} },
    {"EEPROM",              "M24128",               0x54, { 0,0,0} },

    {NULL,                  NULL,                   0,    { 0,0,0} }
  };

const std::vector<std::string> INA226_NAMES_155 = { "POWER_12P0V",   "POWER_VCCINT",
                                                    "POWER_MGTAVCC", "POWER_MGTAVTT",
                                                    "POWER_VCC1V2",  "POWER_VCC1V5",
                                                    "POWER_VCC1V8",  "POWER_VCC2V5",
                                                    "POWER_VCC3V3",  "POWER_VCC3V8",
                                                    "POWER_VCC0V88" };
const float INA226_RSHUNT_155[] = { 1.5, 0.25, 1.0, 1.0, 1.0,
                                    1.0, 1.0, 1.0,  1.0, 1.0, 1.0 };

const std::vector<std::string> TMP435_NAMES_155 = { "TEMP_MGTAVCC", "TEMP_MGTAVTT",
                                                    "TEMP_MGTAVTT2",
                                                    "TEMP_VCC1V5",  "TEMP_VCC1V8",
                                                    "TEMP_VCC3V3",  "TEMP_VCC2V5_3V8",
                                                    "TEMP_VCC0V88" };

const std::vector<std::string> ADM1266_NAMES_155 = { "POWER_SEQ" };

const std::vector<std::string> FF_NAMES_TX_155   = { "FIREFLY1_TX",   "FIREFLY2_TX",
                                                     "FIREFLY3_TX",   "FIREFLY4_TX" };
const std::vector<std::string> FF_NAMES_RX_155   = { "FIREFLY1_RX",   "FIREFLY2_RX",
                                                     "FIREFLY3_RX",   "FIREFLY4_RX", };
const std::vector<std::string> FF_NAMES_TXRX_155 = { "FIREFLY5_TXRX", "FIREFLY6_TXRX" };
const std::vector<std::string> FF_NAMES_155      = { "FIREFLY1_TX",   "FIREFLY1_RX",
                                                     "FIREFLY2_TX",   "FIREFLY2_RX",
                                                     "FIREFLY3_TX",   "FIREFLY3_RX",
                                                     "FIREFLY4_TX",   "FIREFLY4_RX",
                                                     "FIREFLY5_TXRX", "FIREFLY6_TXRX" };
#endif // I2CDEVICES_H
