#ifndef NETIO3BACKEND_UTILITY_HPP
#define NETIO3BACKEND_UTILITY_HPP

#include <string>

#include <boost/asio.hpp>

#include <ers/ers.h>

namespace netio3::utility {
  /**
   * @brief Get the error message for a given error code
   *
   * This function returns the error message for a given error code (errno). If the error code is
   * not known, it returns "Unknown error".
   *
   * @param error The error code to get the message for
   * @return The error message
   */
  [[nodiscard]] std::string error_message(int error);
}  // namespace netio3::utility

#endif  // NETIO3BACKEND_UTILITY_HPP