#ifndef NETIO3BACKEND_ISSUES_HPP
#define NETIO3BACKEND_ISSUES_HPP

#include <format>

#include <ers/ers.h>

ERS_DECLARE_ISSUE(netio3, InvalidEndpointAddress, std::format("The provided endpoint address {}:{} is invalid", ip, port), ((const std::string&) ip)((std::uint16_t) port))
ERS_DECLARE_ISSUE(netio3, ActiveEndpointAlreadyExists, std::format("An active endpoint {}:{} already exists", ip, port), ((const std::string&) ip)((std::uint16_t) port))
ERS_DECLARE_ISSUE(netio3, ListenEndpointAlreadyExists, std::format("A listen endpoint {}:{} already exists", ip, port), ((const std::string&) ip)((std::uint16_t) port))
ERS_DECLARE_ISSUE(netio3, UnknownActiveEndpoint, std::format("No open active endpoint found for {}:{}", ip, port), ((const std::string&) ip)((std::uint16_t) port))
ERS_DECLARE_ISSUE(netio3, UnknownListenEndpoint, std::format("No open listen endpoint found for {}:{}", ip, port), ((const std::string&) ip)((std::uint16_t) port))
ERS_DECLARE_ISSUE(netio3, FailedOpenActiveEndpoint, std::format("Failed to open active endpoint for {}:{}: {}", ip, port, message), ((const std::string&) ip)((std::uint16_t) port)((const std::string&) message))
ERS_DECLARE_ISSUE(netio3, FailedOpenListenEndpoint, std::format("Failed to open listen endpoint for {}:{}: {}", ip, port, message), ((const std::string&) ip)((std::uint16_t) port)((const std::string&) message))
ERS_DECLARE_ISSUE(netio3, FailedCloseActiveEndpoint, std::format("Failed to close active endpoint for {}:{}: {}", ip, port, message), ((const std::string&) ip)((std::uint16_t) port)((const std::string&) message))
ERS_DECLARE_ISSUE(netio3, FailedCloseListenEndpoint, std::format("Failed to close listen endpoint for {}:{}: {}", ip, port, message), ((const std::string&) ip)((std::uint16_t) port)((const std::string&) message))
ERS_DECLARE_ISSUE(netio3, NoBuffersAllocated, std::format("No buffers allocated for endpoint {}:{}", ip, port), ((const std::string&) ip)((std::uint16_t) port))
ERS_DECLARE_ISSUE(netio3, InvalidBuffer, std::format("The provided buffer is not of type {}", type), ((const char*) type))
ERS_DECLARE_ISSUE(netio3, InvalidConnectionParameters, std::format("Invalid connection parameters provided because {}", reason), ((const std::string&) reason))
ERS_DECLARE_ISSUE(netio3, NotSupported, std::format("{}", message), ((const std::string&) message))
ERS_DECLARE_ISSUE(netio3, FailedReceive, std::format("Error receiving message from {}:{}: {}", ip, port, message), ((const std::string&) ip)((std::uint16_t) port)((const std::string&) message))
ERS_DECLARE_ISSUE(netio3, FailedSend, std::format("Error sending message to {}:{}: {}", ip, port, message), ((const std::string&) ip)((std::uint16_t) port)((const std::string&) message))

ERS_DECLARE_ISSUE(netio3, EpollWaitError, std::format("Eventloop: non-blocking epoll_wait returned -1: {}", message), ((const std::string&) message))

#endif  // NETIO3BACKEND_ISSUES_HPP