#ifndef NETIO3_NETIOISSUES_HPP
#define NETIO3_NETIOISSUES_HPP

#include <ers/ers.h>

ERS_DECLARE_ISSUE(netio3,
                  FailedAcknowledge,
                  std::format("Failed to acknowledge {} request for tag {:x}",
                              reqtype, tag),
                  ((std::string) reqtype) ((std::uint64_t) tag))
ERS_DECLARE_ISSUE(netio3,
                  FailedSubscribe,
                  std::format("Failed to send {} request for tag {:x}",
                              reqtype, tag),
                  ((std::string) reqtype) ((std::uint64_t) tag))
ERS_DECLARE_ISSUE(netio3,
                  SubscriptionParseError,
                  std::format("Failed to parse subscription message because: {}. Message was: {}", message, data),
                  ((const std::string&) message)((const std::string&) data))
ERS_DECLARE_ISSUE(netio3,
                  BadRetry,
                  std::format("No vector of failed sends for tag {}", tag),
                  ((uint64_t) tag))

ERS_DECLARE_ISSUE(netio3,
                  AlreadySubscribed,
                  std::format("Already subscribed to tag {:x}", tag),
                  ((uint64_t) tag))

ERS_DECLARE_ISSUE(netio3,
                  NotSubscribed,
                  std::format("Not subscribed to tag {:x}", tag),
                  ((uint64_t) tag))

ERS_DECLARE_ISSUE(netio3,
                  NoConnection,
                  std::format("No open connection to endpoint {}:{}", addr, port),
                              ((std::string) addr) ((uint16_t) port))

ERS_DECLARE_ISSUE(netio3,
                  ConnectionNotIdle,
                  std::format("Refused connection to endpoint {}:{} but connection has tags subscibed", addr, port),
                              ((std::string) addr) ((uint16_t) port))

ERS_DECLARE_ISSUE(netio3,
                  OnPublishCallbackNotAvailable,
                  std::format("On publish completed callback is only available for zero-copy sending"), // cppcheck-suppress syntaxError
                  )

ERS_DECLARE_ISSUE(netio3,
                  WrongPublishMethodCalled,
                  message,
                  ((const std::string&) message)
                  )

#endif  // NETIO3_NETIOISSUES_HPP
