# FelixConfig.cmake.in

####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was FelixConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

# Add FELIX cmake modules to the module path
# This allows find_package() calls for FELIX components to work automatically
list(PREPEND CMAKE_MODULE_PATH "${PACKAGE_PREFIX_DIR}/share/cmake_tdaq/cmake/modules")

# Set the version from your git tag
set(Felix_VERSION "felix-05-02-00-beta-23-3-g63af3ed")

# Available components
set(Felix_AVAILABLE_COMPONENTS
    felix-bus-fs
    felix-client
    felix-client-thread
    felix-interface
    felix-def
    felix-tag
    felix-server
    felix-starter
    hdlc-coder
    netio3
    netio3-backend
)

# Check if components were requested
if(Felix_FIND_COMPONENTS)
    set(Felix_COMPONENTS_TO_FIND ${Felix_FIND_COMPONENTS})
else()
    set(Felix_COMPONENTS_TO_FIND ${Felix_AVAILABLE_COMPONENTS})
endif()

# Initialize target lists
set(Felix_ALL_TARGETS "")
set(Felix_NAMESPACE_TARGETS "")

# Find each requested component
foreach(component ${Felix_COMPONENTS_TO_FIND})
    if(NOT ${component} IN_LIST Felix_AVAILABLE_COMPONENTS)
        set(Felix_FOUND FALSE)
        set(Felix_NOT_FOUND_MESSAGE "Unknown component: ${component}")
        return()
    endif()
    
    find_package(${component} QUIET)
    
    if(${component}_FOUND)
        set(Felix_${component}_FOUND TRUE)
        list(APPEND Felix_FOUND_COMPONENTS ${component})
        
        # Store original CMAKE_FIND_PACKAGE_NAME to restore later
        set(_original_package_name ${CMAKE_FIND_PACKAGE_NAME})
        set(CMAKE_FIND_PACKAGE_NAME ${component})
        
        # Get all targets that were just imported
        get_property(_all_targets DIRECTORY PROPERTY IMPORTED_TARGETS)
        
        foreach(_target ${_all_targets})
            # Check if this target was imported by the current component
            get_target_property(_target_imported_from ${_target} IMPORTED_FROM_PACKAGE)
            if(_target_imported_from STREQUAL ${component} OR _target MATCHES "^${component}")
                list(APPEND Felix_ALL_TARGETS ${_target})
                set_property(TARGET ${_target} PROPERTY IMPORTED_GLOBAL TRUE)
                
                # Create felix:: namespace alias
                string(REGEX REPLACE ".*::" "" _clean_name "${_target}")
                if(NOT TARGET felix::${_clean_name})
                    add_library(felix::${_clean_name} ALIAS ${_target})
                    list(APPEND Felix_NAMESPACE_TARGETS felix::${_clean_name})
                endif()
            endif()
        endforeach()
        
        # Restore CMAKE_FIND_PACKAGE_NAME
        set(CMAKE_FIND_PACKAGE_NAME ${_original_package_name})
    else()
        set(Felix_${component}_FOUND FALSE)
        if(Felix_FIND_REQUIRED_${component})
            set(Felix_FOUND FALSE)
            set(Felix_NOT_FOUND_MESSAGE "Required component ${component} not found")
            return()
        endif()
    endif()
endforeach()

# Set overall found status
if(Felix_FOUND_COMPONENTS)
    set(Felix_FOUND TRUE)
    # Export target lists for users
    set(Felix_TARGETS ${Felix_ALL_TARGETS} CACHE INTERNAL "All Felix targets")
    set(Felix_NAMESPACE_TARGETS ${Felix_NAMESPACE_TARGETS} CACHE INTERNAL "All Felix targets with felix:: namespace")
else()
    set(Felix_FOUND FALSE)
    set(Felix_NOT_FOUND_MESSAGE "No Felix components found")
endif()

if(NOT Felix_FIND_QUIETLY)
    message(STATUS "Found Felix components: ${Felix_FOUND_COMPONENTS}")
    message(STATUS "Available Felix targets: ${Felix_NAMESPACE_TARGETS}")
endif()

check_required_components(Felix)
