from functools import lru_cache

from pydantic_settings import BaseSettings


class Settings(BaseSettings):
    simulate: bool = False
    cache: int = 5
    clear: bool = False
    log_level: str = 'INFO'


@lru_cache
def get_settings():
    return Settings()
