
def decode(name: str, value: int | None) -> str | int | None:

    if value is None:
        return None

    match(name):
        case 'BOARD_ID_TIMESTAMP' | 'GIT_COMMIT_TIME':
            # Board ID Date / Time in BCD format YYMMDDhhmm
            YY = value >> 32 & 0xff
            MM = value >> 24 & 0xff
            DD = value >> 16 & 0xff
            hh = value >> 8 & 0xff
            mm = value & 0xff
            return f'20{YY:02x}-{MM:02x}-{DD:02x} {hh:02x}:{mm:02x}'
        case 'CARD_TYPE':
            match value:
                case 0x2c5: return 'FLX709, VC709'
                case 0x2c6: return 'FLX710, HTG710'
                case 0x2c7: return 'FLX711, BNL711'
                case 0x2c8: return 'FLX712, BNL712'
                case 0x080: return 'FLX128, VCU128'
                case 0x0B4: return 'FLX180, VMK180'
                case 0x0B5: return 'FLX181, BNL181'
                case 0x0B6: return 'FLX182, BNL182'
                case _: return 'Unknown Type'
        case 'GIT_TAG':
            # reverse ASCII-Z string, max 8 chars
            s = ''
            char_value = value & 0xff
            while char_value and len(s) < 8:
                s = s + chr(char_value)
                value = value >> 8
                char_value = value & 0xff
            return s
        case 'REG_MAP_VERSION':
            MM = value >> 8 & 0xff
            mm = value & 0xff
            return f'{MM}.{mm}'
        case 'STATUS_LEDS': return f'0b{value:08b}'
        case _: return value
