import yaml

from pathlib import Path


class I2CBitMap:

    def __init__(self, directory: Path, card_type: str, device_id: int):

        self.bitmap = {}
        bitmap_name = directory / "i2c.yaml"
        with open(bitmap_name) as stream:
            try:
                self.bitmap = yaml.safe_load(stream).get(card_type, {})
            except yaml.YAMLError as exc:
                print(exc)
                exit(1)

    def device_names(self) -> list[str]:
        return self.bitmap.keys()

    def device(self, device_name: str):
        return self.bitmap.get(device_name, {})

    def register_names(self, device_name: str) -> list[str]:
        return self.device(device_name).get('registers', {})

    def register(self, device_name: str, register_name: str):
        return self.device(device_name).get('registers', {}).get(register_name, {})
