from typing import Annotated

from fastapi import APIRouter, Depends, Request
from fastapi.responses import HTMLResponse

from felix_io_api.api import Tags, get_shared


#
# List
#
list_router = APIRouter()


@list_router.get("/list/device/{device_id}/bitfield/{name}", response_class=HTMLResponse, tags=[Tags.list])
async def list_device_bitfield_name(shared: Annotated[dict, Depends(get_shared)],
                                    request: Request,
                                    device_id:  int,
                                    name: str
                                    ) -> str:
    return shared.templates.TemplateResponse(
        request=request, name="bitfield.html", context={"simulate": shared.simulate,
                                                        "hostname": shared.hostname,
                                                        "device_id": device_id,
                                                        "name": name,
                                                        "javascript": f"/js/device/{device_id}/bitfield/{name}"}
    )


@list_router.get("/list/device/{device_id}/bitfield", response_class=HTMLResponse, tags=[Tags.list])
async def list_device_bitfield(shared: Annotated[dict, Depends(get_shared)],
                               request: Request,
                               device_id: int,
                               ) -> str:
    return shared.templates.TemplateResponse(
        request=request, name="bitfield.html", context={"simulate": shared.simulate,
                                                        "hostname": shared.hostname,
                                                        "device_id": device_id,
                                                        "javascript": f"/js/device/{device_id}/bitfield"}
    )


@list_router.get("/list/device/{device_id}/i2c/{name}", response_class=HTMLResponse, tags=[Tags.list])
async def list_device_i2c_name(shared: Annotated[dict, Depends(get_shared)],
                               request: Request,
                               device_id:  int,
                               name: str
                               ) -> str:
    return shared.templates.TemplateResponse(
        request=request, name="bitfield.html", context={"simulate": shared.simulate,
                                                        "hostname": shared.hostname,
                                                        "device_id": device_id,
                                                        "name": name,
                                                        "javascript": f"/js/device/{device_id}/i2c/{name}"}
    )


@list_router.get("/list/device/{device_id}/i2c", response_class=HTMLResponse, tags=[Tags.list])
async def list_device_i2c(shared: Annotated[dict, Depends(get_shared)],
                          request: Request,
                          device_id: int,
                          ) -> str:
    return shared.templates.TemplateResponse(
        request=request, name="bitfield.html", context={"simulate": shared.simulate,
                                                        "hostname": shared.hostname,
                                                        "device_id": device_id,
                                                        "javascript": f"/js/device/{device_id}/i2c"}
    )


@list_router.get("/list/device/{device_id}/alias/{name}", response_class=HTMLResponse, tags=[Tags.list])
async def list_device_alias_name(shared: Annotated[dict, Depends(get_shared)],
                                 request: Request,
                                 device_id:  int,
                                 name: str
                                 ) -> str:
    return shared.templates.TemplateResponse(
        request=request, name="bitfield.html", context={"simulate": shared.simulate,
                                                        "hostname": shared.hostname,
                                                        "device_id": device_id,
                                                        "name": name,
                                                        "javascript": f"/js/device/{device_id}/alias/{name}"}
    )


@list_router.get("/list/device/{device_id}/alias", response_class=HTMLResponse, tags=[Tags.list])
async def list_device_alias(shared: Annotated[dict, Depends(get_shared)],
                            request: Request,
                            device_id: int,
                            ) -> str:
    return shared.templates.TemplateResponse(
        request=request, name="bitfield.html", context={"simulate": shared.simulate,
                                                        "hostname": shared.hostname,
                                                        "device_id": device_id,
                                                        "javascript": f"/js/device/{device_id}/alias"}
    )


@list_router.get("/list/device/{device_id}/group/{name}", response_class=HTMLResponse, tags=[Tags.list])
async def list_device_group_name(shared: Annotated[dict, Depends(get_shared)],
                                 request: Request,
                                 device_id:  int,
                                 name: str
                                 ) -> str:
    return shared.templates.TemplateResponse(
        request=request, name="bitfield.html", context={"simulate": shared.simulate,
                                                        "hostname": shared.hostname,
                                                        "device_id": device_id,
                                                        "name": name,
                                                        "javascript": f"/js/device/{device_id}/group/{name}"}
    )


@list_router.get("/list/device/{device_id}/group", response_class=HTMLResponse, tags=[Tags.list])
async def list_device_group(shared: Annotated[dict, Depends(get_shared)],
                            request: Request,
                            device_id: int,
                            ) -> str:
    return shared.templates.TemplateResponse(
        request=request, name="bitfield.html", context={"simulate": shared.simulate,
                                                        "hostname": shared.hostname,
                                                        "device_id": device_id,
                                                        "javascript": f"/js/device/{device_id}/group"}
    )


# list client-side fpga
@list_router.get("/list/device/{device_id}/fpga", response_class=HTMLResponse, tags=[Tags.list])
async def list_fpga(shared: Annotated[dict, Depends(get_shared)],
                    request: Request,
                    device_id:  int,
                    ) -> str:
    return shared.templates.TemplateResponse(
        request=request, name="bitfield.html", context={"simulate": shared.simulate,
                                                        "hostname": shared.hostname,
                                                        "device_id": device_id,
                                                        "javascript": f'/js/device/{device_id}?' +
                                                        "&".join(['name=' + sub for sub in [
                                                                    'TACH_CNT', 'FPGA_DNA', 'FPGA_CORE_VCCINT', 'FPGA_CORE_VCCAUX', 'FPGA_CORE_VCCBRAM', 'FPGA_CORE_TEMP'
                                                                ]
                                                            ])
                                                        }
    )


# list client-side git_info
@list_router.get("/list/device/{device_id}/git_info", response_class=HTMLResponse, tags=[Tags.list])
async def list_git_info(shared: Annotated[dict, Depends(get_shared)],
                        request: Request,
                        device_id:  int,
                        ) -> str:
    return shared.templates.TemplateResponse(
        request=request, name="bitfield.html", context={"simulate": shared.simulate,
                                                        "hostname": shared.hostname,
                                                        "device_id": device_id,
                                                        "javascript": f'/js/device/{device_id}?' +
                                                        "&".join(['name=' + sub for sub in [
                                                                    'REG_MAP_VERSION', 'BOARD_ID_TIMESTAMP', 'GIT_COMMIT_TIME', 'GIT_TAG', 'GIT_COMMIT_NUMBER', 'GIT_HASH'
                                                                ]
                                                            ])
                                                        }
    )


@list_router.get("/list/device/{device_id}/{name}", response_class=HTMLResponse, tags=[Tags.list])
async def list_device_name(shared: Annotated[dict, Depends(get_shared)],
                           request: Request,
                           device_id:  int,
                           name: str
                           ) -> str:
    return shared.templates.TemplateResponse(
        request=request, name="bitfield.html", context={"simulate": shared.simulate,
                                                        "hostname": shared.hostname,
                                                        "device_id": device_id,
                                                        "name": name,
                                                        "javascript": f"/js/device/{device_id}/{name}"}
    )


@list_router.get("/list/device/{device_id}", response_class=HTMLResponse, tags=[Tags.list])
async def list_device(shared: Annotated[dict, Depends(get_shared)],
                      request: Request,
                      device_id: int,
                      ) -> str:
    return shared.templates.TemplateResponse(
        request=request, name="bitfield.html", context={"simulate": shared.simulate,
                                                        "hostname": shared.hostname,
                                                        "device_id": device_id,
                                                        "javascript": f"/js/device/{device_id}"}
    )


@list_router.get("/list", response_class=HTMLResponse, tags=[Tags.list])
async def list_device_list(shared: Annotated[dict, Depends(get_shared)],
                           request: Request
                           ) -> str:
    return shared.templates.TemplateResponse(
        request=request, name="device_list.html", context={"simulate": shared.simulate,
                                                           "hostname": shared.hostname}
    )
