import json
import yaml

from pathlib import Path

from felix_io_api.api import BitFieldInfoRecord

from .config import get_settings
from .util import Util


class RegBitMap:

    regbitmap_list = {}
    regbitmap_extra = None

    def __init__(self, version: int, directory: Path, device_id: int):
        self.logger = Util.get_logger(__name__, get_settings().log_level)

        # cache the regbitmap(s)
        if version not in RegBitMap.regbitmap_list:
            regbitmap_name = directory / f"regbitmap{version}-symbol.json"
            with open(regbitmap_name) as stream:
                self.logger.info(f"   Reading regbitmap: {regbitmap_name}")
                RegBitMap.regbitmap_list[version] = json.load(stream)
        self.regbitmap = RegBitMap.regbitmap_list[version]
        self.logger.info(f"   # of bitfields: {len(self.bitfield_names())}")

        # cache the regbitmap_extra(s)
        if not RegBitMap.regbitmap_extra:
            # read regbitmap_extra to add extra items to the registermap
            regbitmap_extra_name = directory / "regbitmap-extra.yaml"
            with open(regbitmap_extra_name) as stream:
                try:
                    RegBitMap.regbitmap_extra = yaml.safe_load(stream)
                except yaml.YAMLError as exc:
                    print(exc)
                    exit(1)

            # add extra definitions (power, multiply, divide, offset, min, max, clear) to register map
            # create groups from the register
            for bitfield_name in RegBitMap.regbitmap_extra['registers']:
                bitfield = self.get_bitfield(bitfield_name)
                for definition, value in RegBitMap.regbitmap_extra['registers'][bitfield_name].items():
                    bitfield[definition] = value

    def bitfield_names(self) -> list[str]:
        return self.regbitmap['bitfields'].keys()

    def get_bitfield(self, name) -> BitFieldInfoRecord:
        return self.regbitmap['bitfields'][name]

    def register_names(self) -> list[str]:
        return self.regbitmap['registers'].keys()

    # FIXME use RegisterDef
    def get_register(self, name) -> BitFieldInfoRecord:
        return self.regbitmap['registers'][name]
