from .test_util import get, get_ref


def test_alias_list(client):
    response = get(client, "/api/device/2/alias")
    assert len(response.json()) == get(client, "/number_of_aliases/device/2").json()


def test_alias_FPGA_Temperature(client):
    ref = get_ref('FPGA_Temperature.json')
    get(client, "/api/card/1/alias/FPGA_Temperature", ref)


def test_alias_FPGA_Temperature_info(client):
    ref = get_ref('FPGA_Temperature_info.json')
    get(client, "/api/card/1/alias/FPGA_Temperature?info=True", ref)


def test_alias_device_not_found(client):
    get(client, "/api/card/99/alias/FPGA_Temperature", status_code=404)


def test_alias_field_not_found(client):
    get(client, "/api/card/1/alias/does_not_exist", status_code=404)
