from .test_util import get, post, put, get_ref


def test_api_card(client):
    ref = get_ref('cards.json')
    get(client, "/api", ref)


def test_api_bitfield(client):
    ref = get_ref('REG_MAP_VERSION.json')
    get(client, "/api/device/0/REG_MAP_VERSION", ref)


def test_api_bitfield_card(client):
    ref = get_ref('REG_MAP_VERSION.json')
    get(client, "/api/card/0/REG_MAP_VERSION", ref)


def test_api_i2c(client):
    ref = get_ref("i2c_TEMP_LTM4642_t_local_degrees.json")
    get(client, "/api/card/2/TEMP_LTM4642:t_local_degrees", ref)


def test_api_alias(client):
    ref = get_ref('FPGA_Temperature.json')
    get(client, "/api/device/1/FPGA_Temperature", ref)


def test_api_alias_card(client):
    ref = get_ref('FPGA_Temperature.json')
    get(client, "/api/card/1/FPGA_Temperature", ref)


def test_api_group(client):
    ref = get_ref("device_info.json")
    get(client, "/api/device/1/device_info", ref)


def test_api_group_card(client):
    ref = get_ref("device_info.json")
    get(client, "/api/card/1/device_info", ref)


def test_api_device_not_found(client):
    get(client, "/api/device/99/device_info", status_code=404)


def test_api_field_not_found(client):
    get(client, "/api/device/1/does_not_exist", status_code=404)


bitfields = ['TACH_CNT', 'LTC2991-1:VCCINT voltage', 'FPGA_Temperature', 'device_info']


def test_api_post(client):
    ref = get_ref('post.json')
    post(client, "/api/device/1", bitfields, ref)


def test_api_post_card(client):
    ref = get_ref('post.json')
    post(client, "/api/card/1", bitfields, ref)


def test_api_post_device_not_found(client):
    post(client, "/api/card/99", bitfields, status_code=404)


non_existing_bitfields = ['NOT_EXIST', 'AND_ANOTHER_ONE']


def test_api_post_field_not_found(client):
    post(client, "/api/card/1", non_existing_bitfields, status_code=404)


def test_api_put(client):
    value = 42
    x1 = put(client, "/api/device/0/FMEMU_CONFIG_WE", {'value': value}).json()
    assert x1['FMEMU_CONFIG_WE']['value'] == value


def test_api_put_device_not_found(client):
    value = 42
    put(client, "/api/device/99/FMEMU_CONFIG_WE", {'value': value}, status_code=404)


def test_api_put_field_not_found(client):
    value = 42
    put(client, "/api/device/0/NON_EXISTING", {'value': value}, status_code=404)


def test_api_put_value_not_supplied(client):
    value = 42
    put(client, "/api/card/0/FMEMU_CONFIG_WE", {'non-existing': value}, status_code=422)
