from .test_util import get, get_ref


def test_bitfield_list_device_0(client):
    response = get(client, "/api/device/0/bitfield")
    assert len(response.json()) == get(client, "/number_of_bitfields/device/0").json()


def test_bitfield_list_device_2(client):
    response = get(client, "/api/device/2/bitfield")
    # FIXME should probably be less if we take into account that endpoint1 has fewer bitfields to read
    assert len(response.json()) == get(client, "/number_of_bitfields/device/2").json()


def test_bitfield_card_0(client):
    response = get(client, "/api/card/0/bitfield")
    assert len(response.json()) == get(client, "/number_of_bitfields/card/0").json()


def test_bitfield_card_1(client):
    response = get(client, "/api/card/1/bitfield")
    assert len(response.json()) == get(client, "/number_of_bitfields/card/1").json()


def test_bitfield_REG_MAP_VERSION_device_0(client):
    ref = get_ref('REG_MAP_VERSION.json')
    get(client, "/api/device/0/bitfield/REG_MAP_VERSION", ref)


def test_bitfield_REG_MAP_VERSION_card_0(client):
    ref = get_ref('REG_MAP_VERSION.json')
    get(client, "/api/card/0/bitfield/REG_MAP_VERSION", ref)


def test_bitfield_REG_MAP_VERSION_info(client):
    ref = get_ref('REG_MAP_VERSION_info.json')
    get(client, "/api/card/0/bitfield/REG_MAP_VERSION?info=True", ref)


def test_bitfield_device_not_found(client):
    get(client, "/api/card/99/bitfield/REG_MAP_VERSION", status_code=404)


def test_bitfield_not_found(client):
    get(client, "/api/card/0/bitfield/DOES_NOT_EXIST", status_code=404)
