from .test_util import get, get_ref, clear_cache


def test_cache_TEMP_LTM4642_t_local_degrees(client):
    clear_cache()

    card_id = 2
    device_name = 'TEMP_LTM4642'
    register_name = 't_local_degrees'
    key = f"{device_name}:{register_name}"

    url = f"/api/card/{card_id}/i2c/{device_name}:{register_name}"

    ref = get_ref("i2c_TEMP_LTM4642_t_local_degrees.json")
    response = get(client, url, ref)
    print(response.json())
    assert key in response.json()
    assert 'ttl' not in response.json()[key]

    response = get(client, f"/card_to_device_id/{card_id}")
    device_id = response.json()
    assert device_id == 3

    # number of locks == 1 as we reading i2c above
    locks = f"/number_of_locks/device/{device_id}"
    response = get(client, locks)
    current_locks = response.json()

    response = get(client, url, ref)
    print(response.json())
    assert key in response.json()
    assert 'ttl' in response.json()[key]
    assert response.json()[key]['ttl'] > 1

    # number of locks == 1 as we reading the cache so no extra lock was needed
    response = get(client, locks)
    assert response.json() == current_locks
