from ..constants import APPLICATION_JSON
from .test_util import get, get_ref


def test_data(client):
    ref = {
        'data': [{
            'name': 'Device #0',
            'device_id': 0,
            'card_id': 0,
            'card_type': 'FLX709, VC709'
        }, {
            'name': 'Device #1',
            'device_id': 1,
            'card_id': 1,
            'card_type': 'FLX712, BNL712'
        }, {
            'name': 'Device #2',
            'device_id': 2,
            'card_id': 1,
            'card_type': 'FLX712, BNL712'
        }, {
            'card_id': 2,
            'card_type': 'FLX182, BNL182',
            'device_id': 3,
            'name': 'Device #3'
        }, {
            'card_id': 2,
            'card_type': 'FLX182, BNL182',
            'device_id': 4,
            'name': 'Device #4'
        }]
    }
    get(client, "/data", ref, APPLICATION_JSON)


def test_data_d0(client):
    get(client, "/data/device/0", content_type=APPLICATION_JSON)


def test_data_bitfield_REG_MAP_VERSION(client):
    ref = {
        'data': [{
            'desc': 'Register Map Version, 5.3 formatted as 0x0503',
            'address': '0',
            'mask': '65535',
            'bf_hi': '15',
            'bf_lo': '0',
            'fw_modes': '',
            'type': 'REGMAP_REG_READ',
            'endpoints': 'REGMAP_ENDPOINT_0|REGMAP_ENDPOINT_1',
            'name': 'REG_MAP_VERSION',
            'value': '5.1',
            'raw_value': '1281',
            'unit': '',
            'decoded_value': '5.1',
            'alias': '',
            'group': 'device_info',
            'convert': '',
            'power': '',
            'multiply': '',
            'divide': '',
            'offset': '',
            'clear': ''
        }]
    }
    get(client, "/data/device/0/bitfield/REG_MAP_VERSION", ref, APPLICATION_JSON)


def test_data_i2c_TEMP_LTM4642_t_local_degrees(client):
    ref = {
        'data': [{
            'address': '0',
            'bf_hi': '7',
            'bf_lo': '0',
            'decoded_value': '26.5 C',
            'desc': 'TBS',
            'endpoints': 'n/a',
            'fw_modes': 'n/a',
            'mask': '255',
            'name': 'TEMP_LTM4642:t_local_degrees',
            'raw_value': '26',
            'type': 'byte',
            'unit': 'C',
            'value': '26.5',
            'alias': '',
            'group': 'temperature',
            'convert': '',
            'power': '',
            'multiply': '',
            'divide': '',
            'offset': '',
            'clear': ''
        }]
    }
    get(client, "/data/device/3/i2c/TEMP_LTM4642:t_local_degrees", ref, APPLICATION_JSON)


def test_data_alias_FPGA_Temperature(client):
    ref = {
        'data': [{
            'address': '18',
            'bf_hi': '13',
            'bf_lo': '0',
            'decoded_value': '66.4375 C',
            'desc': 'TBS',
            'endpoints': 'n/a',
            'fw_modes': 'n/a',
            'mask': '16383',
            'name': 'FPGA_Temperature:LTC2991-1:FPGA internal diode temperature',
            'raw_value': '1063',
            'type': 'word',
            'unit': 'C',
            'value': '66.4375',
            'alias': 'FPGA_Temperature',
            'group': 'temperature',
            'convert': '',
            'power': '',
            'multiply': '0.0625',
            'divide': '',
            'offset': '',
            'clear': ''
        }]
    }
    get(client, "/data/device/1/alias/FPGA_Temperature", ref, APPLICATION_JSON)


def xtest_data_group_device_info(client):
    ref = get_ref("data_device_info.json")
    get(client, "/data/device/0/group/device_info", ref)
