from ..driver import linear11, linear16, FlxCard


def test_driver_linear11():
    assert linear11(0xBE00) == -1

    assert linear11(0xBABF) == 1.373046875
    assert linear11(0xBA4F) == 1.154296875
    assert linear11(0xB207) == 0.5068359375
    assert linear11(0xABEC) == 0.490234375
    assert linear11(0x8004) == 6.103515625e-05
    assert linear11(0x8000) == 0
    assert linear11(0xAAAA) == 0.3330078125
    assert linear11(0x8354) == 0.01300048828125
    assert linear11(0xB40F) == -0.9853515625
    assert linear11(0xBBC0) == 1.875
    assert linear11(0xB480) == -0.875
    assert linear11(0x9B01) == 0.0938720703125
    assert linear11(0xCB24) == 6.28125
    assert linear11(0xC3E8) == 3.90625

    assert linear11(0x9807) == 0.0008544921875

    assert linear11(0xe22f) == 34.9375
    assert linear11(0xcacd) == 5.6015625
    assert linear11(0xcb7f) == 6.9921875
    assert linear11(0xe23e) == 35.875
    assert linear11(0x8354) == 0.01300048828125
    assert linear11(0xca38) == 4.4375
    assert linear11(0xcac6) == 5.546875
    assert linear11(0xd3d0) == 15.25
    assert linear11(0xe2a9) == 42.5625
    assert linear11(0xba7f) == 1.248046875
    assert linear11(0xD30e) == 12.21875


def test_driver_linear16():
    assert linear16(0x4C00) == 4.75

    assert linear16(0x0cd1) == 0.801025390625
    assert linear16(0x0ccf) == 0.800537109375


def test_driver_open_close():
    device_id = 2

    card = FlxCard(simulate=True)
    card.reset_statistics(device_id)

    assert card.open(device_id, 'test') == (1, 0)  # opens card
    assert card.close(device_id, 'test') == (0, 0)

    assert card.number_of_opens(device_id) == 1
    assert card.number_of_locks(device_id) == 0


def test_driver_open_close_4x():
    device_id = 2

    card = FlxCard(simulate=True)
    card.reset_statistics(device_id)

    assert card.open(device_id, 'test1') == (1, 0)  # opens card
    assert card.open(device_id, 'test2') == (2, 0)
    assert card.open(device_id, 'test3') == (3, 0)
    assert card.open(device_id, 'test4') == (4, 0)
    assert card.close(device_id, 'test4') == (3, 0)
    assert card.close(device_id, 'test3') == (2, 0)
    assert card.close(device_id, 'test2') == (1, 0)
    assert card.close(device_id, 'test1') == (0, 0)

    assert card.number_of_opens(device_id) == 1
    assert card.number_of_locks(device_id) == 0


def test_driver_lock_unlock():
    device_id = 2

    card = FlxCard(simulate=True)
    card.reset_statistics(device_id)

    assert card.lock(device_id, 'test') == (1, 1)  # opens and locks card
    assert card.unlock(device_id, 'test') == (0, 0)

    assert card.number_of_opens(device_id) == 1
    assert card.number_of_locks(device_id) == 0


def test_driver_lock_unlock_now():
    device_id = 2

    card = FlxCard(simulate=True)
    card.reset_statistics(device_id)

    assert card.lock(device_id, 'test', now=True) == (1, 1)  # opens and locks card
    assert card.unlock(device_id, 'test') == (0, 0)

    assert card.number_of_opens(device_id) == 1
    assert card.number_of_locks(device_id) == 1


def test_driver_lock_unlock_2x_now():
    device_id = 2

    card = FlxCard(simulate=True)
    card.reset_statistics(device_id)

    assert card.lock(device_id, 'test1', now=True) == (1, 1)  # opens and locks card
    assert card.unlock(device_id, 'test1') == (0, 0)

    assert card.lock(device_id, 'test2', now=True) == (1, 1)  # opens and locks card
    assert card.unlock(device_id, 'test2') == (0, 0)

    assert card.number_of_opens(device_id) == 2
    assert card.number_of_locks(device_id) == 2


def test_driver_lock_unlock_4x():
    device_id = 2

    card = FlxCard(simulate=True)
    card.reset_statistics(device_id)

    assert card.lock(device_id, 'test1') == (1, 1)  # opens card
    assert card.lock(device_id, 'test2') == (2, 2)
    assert card.lock(device_id, 'test3') == (3, 3)
    assert card.lock(device_id, 'test4') == (4, 4)
    assert card.unlock(device_id, 'test4') == (3, 3)
    assert card.unlock(device_id, 'test3') == (2, 2)
    assert card.unlock(device_id, 'test2') == (1, 1)
    assert card.unlock(device_id, 'test1') == (0, 0)

    assert card.number_of_opens(device_id) == 1
    assert card.number_of_locks(device_id) == 0


def test_driver_lock_unlock_4x_now():
    device_id = 2

    card = FlxCard(simulate=True)
    card.reset_statistics(device_id)

    assert card.lock(device_id, 'test1') == (1, 1)  # opens card
    assert card.lock(device_id, 'test2', now=True) == (2, 2)  # re-opens card to lock
    assert card.lock(device_id, 'test3') == (3, 3)
    assert card.lock(device_id, 'test4', now=True) == (4, 4)
    assert card.unlock(device_id, 'test4') == (3, 3)
    assert card.unlock(device_id, 'test3') == (2, 2)
    assert card.unlock(device_id, 'test2') == (1, 1)
    assert card.unlock(device_id, 'test1') == (0, 0)

    assert card.number_of_opens(device_id) == 2
    assert card.number_of_locks(device_id) == 1


def test_driver_lock_open_lock_unlock_now():
    device_id = 2

    card = FlxCard(simulate=True)
    card.reset_statistics(device_id)

    assert card.open(device_id, 'test1') == (1, 0)  # opens card
    assert card.open(device_id, 'test2') == (2, 0)
    assert card.lock(device_id, 'test3') == (3, 1)
    assert card.lock(device_id, 'test4', now=True) == (4, 2)  # re-opens card to lock
    assert card.unlock(device_id, 'test4') == (3, 1)
    assert card.unlock(device_id, 'test3') == (2, 0)  # re-opens card unlocked
    assert card.close(device_id, 'test2') == (1, 0)
    assert card.close(device_id, 'test1') == (0, 0)

    assert card.number_of_opens(device_id) == 3
    assert card.number_of_locks(device_id) == 1


def test_driver_lock_open_lock_open_unlock_now():
    device_id = 2

    card = FlxCard(simulate=True)
    card.reset_statistics(device_id)

    assert card.open(device_id, 'test1') == (1, 0)  # opens card
    assert card.open(device_id, 'test2') == (2, 0)
    assert card.lock(device_id, 'test3') == (3, 1)
    assert card.lock(device_id, 'test4', now=True) == (4, 2)  # re-opens card to lock
    assert card.open(device_id, 'test5') == (5, 3)
    assert card.lock(device_id, 'test6', now=True) == (6, 4)

    assert card.unlock(device_id, 'test6') == (5, 3)
    assert card.close(device_id, 'test5') == (4, 2)
    assert card.unlock(device_id, 'test4') == (3, 1)
    assert card.unlock(device_id, 'test3') == (2, 0)  # re-opens card unlocked
    assert card.close(device_id, 'test2') == (1, 0)
    assert card.close(device_id, 'test1') == (0, 0)

    assert card.number_of_opens(device_id) == 3
    assert card.number_of_locks(device_id) == 1
