from .test_util import get


def test_group_list(client):
    response = get(client, "/api/device/2/group")
    assert len(response.json()) == get(client, "/number_of_groups/device/2").json()


def test_group_device_info(client):
    response = get(client, "/api/device/0/group/device_info")
    assert len(response.json().keys()) == 19


def test_group_device_info_card(client):
    response = get(client, "/api/card/0/group/device_info")
    assert len(response.json().keys()) == 19


def test_group_device_not_found(client):
    get(client, "/api/device/99/group/device_info", status_code=404)


def test_group_field_not_found(client):
    get(client, "/api/device/0/group/does_not_exist", status_code=404)
