from .test_util import get, get_ref, clear_cache


def test_i2c_list(client):
    response = get(client, "/api/device/2/i2c")
    assert len(response.json()) == get(client, "/number_of_i2cs/device/2").json()


def test_i2c_TEMP_LTM4642_t_local_degrees(client):
    clear_cache()

    ref = get_ref("i2c_TEMP_LTM4642_t_local_degrees.json")
    get(client, "/api/card/2/i2c/TEMP_LTM4642:t_local_degrees", ref)


def test_i2c_1st_RX_Power(client):
    clear_cache()

    ref = get_ref("i2c_1st_RX_Power.json")
    get(client, "/api/card/1/i2c/1st RX:Power", ref)


def test_i2c_device_not_found(client):
    get(client, "/api/card/99/i2c/1st RX:Power", status_code=404)


def test_i2c_illegal_name(client):
    clear_cache()

    get(client, "/api/card/2/i2c/device_does_not_exist", status_code=404)


def test_i2c_not_found(client):
    clear_cache()

    get(client, "/api/card/1/i2c/1st RX:register_does_not_exist", status_code=404)
