from ..constants import TEXT_JAVASCRIPT
from .test_util import get


def test_js_device_list(client):
    response = get(client, "/js/device_list/", content_type=TEXT_JAVASCRIPT)
    assert "ajax: '/data'" in response.text


def test_js_device(client):
    response = get(client, "/js/device/0", content_type=TEXT_JAVASCRIPT)
    assert "url: '/data/device/0'" in response.text


def test_js_bitfield(client):
    response = get(client, "/js/device/0/bitfield", content_type=TEXT_JAVASCRIPT)
    assert "url: '/data/device/0/bitfield'" in response.text


def test_js_i2c(client):
    response = get(client, "/js/device/0/i2c", content_type=TEXT_JAVASCRIPT)
    assert "url: '/data/device/0/i2c'" in response.text


def test_js_alias(client):
    response = get(client, "/js/device/0/alias", content_type=TEXT_JAVASCRIPT)
    assert "url: '/data/device/0/alias'" in response.text


def test_js_group(client):
    response = get(client, "/js/device/0/group", content_type=TEXT_JAVASCRIPT)
    assert "url: '/data/device/0/group'" in response.text


def test_js_device_device_info(client):
    response = get(client, "/js/device/0/device_info", content_type=TEXT_JAVASCRIPT)
    assert "url: '/data/device/0/device_info'" in response.text


def test_js_bitfield_REG_MAP_VERSION(client):
    response = get(client, "/js/device/0/bitfield/REG_MAP_VERSION", content_type=TEXT_JAVASCRIPT)
    assert "url: '/data/device/0/bitfield/REG_MAP_VERSION'" in response.text


def test_js_i2c_TEMP_LTM4642_t_local_degrees(client):
    response = get(client, "/js/device/3/i2c/TEMP_LTM4642:t_local_degrees", content_type=TEXT_JAVASCRIPT)
    assert "url: '/data/device/3/i2c/TEMP_LTM4642:t_local_degrees'" in response.text


def test_js_alias_fpga(client):
    response = get(client, "/js/device/1/alias/fpga", content_type=TEXT_JAVASCRIPT)
    assert "url: '/data/device/1/alias/fpga'" in response.text


def test_js_group_device_info(client):
    response = get(client, "/js/device/0/device_info", content_type=TEXT_JAVASCRIPT)
    assert "url: '/data/device/0/device_info'" in response.text


def test_js_device_q_name(client):
    response = get(client, "/js/device/0?name=REG_MAP_VERSION", content_type=TEXT_JAVASCRIPT)
    assert "url: '/data/device/0'" in response.text
    assert "type: 'POST'" in response.text
