from ..constants import TEXT_HTML
from .test_util import get


def test_list(client):
    response = get(client, "/list", content_type=TEXT_HTML)
    assert "<script src=\"/js/device_list\"></script>" in response.text


def test_list_device(client):
    response = get(client, "/list/device/0", content_type=TEXT_HTML)
    assert "<script src=\"/js/device/0\"></script>" in response.text


def test_list_bitfield(client):
    response = get(client, "/list/device/0/bitfield", content_type=TEXT_HTML)
    assert "<script src=\"/js/device/0/bitfield\"></script>" in response.text


def test_list_i2c(client):
    response = get(client, "/list/device/0/i2c", content_type=TEXT_HTML)
    assert "<script src=\"/js/device/0/i2c\"></script>" in response.text


def test_list_alias(client):
    response = get(client, "/list/device/0/alias", content_type=TEXT_HTML)
    assert "<script src=\"/js/device/0/alias\"></script>" in response.text


def test_list_group(client):
    response = get(client, "/list/device/0/group", content_type=TEXT_HTML)
    assert "<script src=\"/js/device/0/group\"></script>" in response.text


def test_list_device_info(client):
    response = get(client, "/list/device/0/device_info", content_type=TEXT_HTML)
    assert "<script src=\"/js/device/0/device_info\"></script>" in response.text


def test_list_bitfield_REG_MAP_VERSION(client):
    response = get(client, "/list/device/0/bitfield/REG_MAP_VERSION", content_type=TEXT_HTML)
    assert "<script src=\"/js/device/0/bitfield/REG_MAP_VERSION\"></script>" in response.text


def test_list_i2c_TEMP_LTM4642_t_local_degrees(client):
    response = get(client, "/list/device/3/i2c/TEMP_LTM4642:t_local_degrees", content_type=TEXT_HTML)
    assert "<script src=\"/js/device/3/i2c/TEMP_LTM4642:t_local_degrees\"></script>" in response.text


def test_list_alias_fpga(client):
    response = get(client, "/list/device/1/alias/fpga", content_type=TEXT_HTML)
    assert "<script src=\"/js/device/1/alias/fpga\"></script>" in response.text


def test_list_group_device_info(client):
    response = get(client, "/list/device/0/group/device_info", content_type=TEXT_HTML)
    assert "<script src=\"/js/device/0/group/device_info\"></script>" in response.text


def test_list_git_info(client):
    response = get(client, "/list/device/0/git_info", content_type=TEXT_HTML)
    assert "<script src=\"/js/device/0?name=REG_MAP_VERSION" in response.text
