from .test_util import post, get_ref


git_bitfields = ['GIT_COMMIT_TIME', 'GIT_TAG', 'GIT_COMMIT_NUMBER']


def test_post_git_info(client):
    ref = get_ref('git_info.json')
    post(client, "/api/device/0", git_bitfields, ref)


def test_post_git_info_card(client):
    ref = get_ref('git_info.json')
    post(client, "/api/card/0", git_bitfields, ref)


fpga_bitfields = ['TACH_CNT', 'FPGA_DNA', 'FPGA_CORE_VCCINT', 'FPGA_CORE_VCCAUX', 'FPGA_CORE_VCCBRAM', 'FPGA_CORE_TEMP']


def test_post_fpga(client):
    ref = get_ref('fpga_post.json')
    post(client, "/api/device/1", fpga_bitfields, ref)


def test_post_fpga_card(client):
    ref = get_ref('fpga_post.json')
    post(client, "/api/card/1", fpga_bitfields, ref)


def test_post_fpga_info_card(client):
    ref = get_ref('fpga_post_info.json')
    post(client, "/api/card/1?info=True", fpga_bitfields, ref)


def test_post_device_not_found(client):
    post(client, "/api/card/99?info=True", fpga_bitfields, status_code=404)


non_existing_bitfields = ['NOT_EXIST', 'AND_ANOTHER_ONE']


def test_post_field_not_found(client):
    post(client, "/api/card/1?info=True", non_existing_bitfields, status_code=404)
