import random

from .test_util import get, put


def put_test(client, url):
    new_value = random.randint(0, 100)

    # Read old_value
    x0 = get(client, url).json()
    old_value = x0['FMEMU_CONFIG_WE']['value']

    # Set to value
    x1 = put(client, url, {'value': new_value}).json()
    assert x1['FMEMU_CONFIG_WE']['value'] == new_value

    # Read new_value
    assert get(client, url).json() == x1

    # Set back to old_value
    assert put(client, url, {'value': old_value}).json() == x0

    # Read
    assert get(client, url).json() == x0


def test_put_bitfield(client):
    put_test(client, "/api/device/0/bitfield/FMEMU_CONFIG_WE")


def test_put_bitfield_card(client):
    put_test(client, "/api/card/0/bitfield/FMEMU_CONFIG_WE")


def test_put_bitfield_device_not_found(client):
    new_value = random.randint(0, 100)
    put(client, "/api/card/99/bitfield/FMEMU_CONFIG_WE", {'value': new_value}, status_code=404)


def test_put_bitfield_field_not_found(client):
    new_value = random.randint(0, 100)
    put(client, "/api/card/0/bitfield/DOES_NOT_EXIST", {'value': new_value}, status_code=404)


def test_put_bitfield_no_value(client):
    new_value = random.randint(0, 100)
    put(client, "/api/card/0/bitfield/FMEMU_CONFIG_WE", {'non-existing': new_value}, status_code=422)
