from ..constants import APPLICATION_JSON, IMAGE_VND_MICROSOFT_ICON, TEXT_HTML
from .test_util import get


def test_support_get(client):
    get(client, "/", content_type=TEXT_HTML)


def test_support_get_index(client):
    get(client, "/index.html", content_type=TEXT_HTML)


def test_support_get_favicon(client):
    get(client, "/favicon.ico", content_type=IMAGE_VND_MICROSOFT_ICON)


def test_support_get_settings(client):
    get(client, "/settings", json_ref={'simulate': True, 'clear': False, 'cache': 5, 'log_level': 'INFO'}, content_type=APPLICATION_JSON)


def xtest_support_get_shared(client):
    get(client, "/shared", json_ref={}, content_type=APPLICATION_JSON)


def test_support_number_of_bitfields(client):
    assert get(client, "/number_of_bitfields/device/0").json() > 4500


def test_support_number_of_bitfields_card(client):
    assert get(client, "/number_of_bitfields/card/0").json() > 4500
