import json

from deepdiff import DeepDiff
from pathlib import Path

from felix_io_api.api import get_shared
from ..constants import APPLICATION_JSON

from ..flxcard_simulator import flxcard as flxcard_simulator


def check(response, json_ref, content_type, status_code):
    assert response.status_code == status_code
    assert response.headers['content-type'].split(';')[0] == content_type
    if json_ref:
        print(json.dumps(response.json(), indent=4, sort_keys=True))
        if type(json_ref) is dict:
            exclude_paths = [
                r"root\['ttl'\]",
                r"root\[\'.+'\]\['ttl'\]",
                r"root\[\'.+'\]\['desc'\]",
                r"root\[\'data'\]\[\d+]\['desc'\]"
            ]
            diff = DeepDiff(json_ref, response.json(), exclude_regex_paths=exclude_paths)
            print(diff)
            assert diff == {}
        else:
            assert response.json() == json_ref
    assert flxcard_simulator.open_device is None, f"flxcard closed with a currently opened or locked device {flxcard_simulator.open_device}"
    return response


def get(client, url, json_ref=None, content_type=APPLICATION_JSON, status_code=200):
    assert flxcard_simulator.open_device is None, f"flxcard GET with a currently opened or locked device {flxcard_simulator.open_device}"
    return check(client.get(url), json_ref, content_type, status_code)


def post(client, url, json_data, json_ref=None, content_type=APPLICATION_JSON, status_code=200):
    assert flxcard_simulator.open_device is None, f"flxcard POST with a currently opened or locked device {flxcard_simulator.open_device}"
    return check(client.post(url, json=json_data), json_ref, content_type, status_code)


def put(client, url, json_params=None, json_ref=None, content_type=APPLICATION_JSON, status_code=200):
    assert flxcard_simulator.open_device is None, f"flxcard PUT with a currently opened or locked device {flxcard_simulator.open_device}"
    return check(client.put(url, params=json_params), json_ref, content_type, status_code)


def get_ref(ref_file: Path):
    directory = Path(__file__).parent
    with open(directory / ref_file) as stream:
        return json.load(stream)


def clear_cache():
    get_shared().cache.flushdb()
