import logging

from pathlib import Path


class Util:

    def project_root() -> Path:
        # Find the project root
        # absolute path up from 'felix_io/util.py'
        project_root = Path(__file__).parent.parent
        if not (project_root / 'share' / 'felix-io').is_dir():
            # remove 'python' directory
            project_root = project_root.parent
        project_root = project_root.resolve()
        assert project_root is not None
        return project_root

    def get_logger(name: str, level: str = logging.INFO):
        # FIXME do not seem to be able to use name...
        logger = logging.getLogger('uvicorn.error')
        logger.setLevel(level)

        return logger
