#[=======================================================================[.rst:
FindCURL
-------------

Finds the curl library.

Imported Targets
^^^^^^^^^^^^^^^^

This module provides the following imported targets, if found:

``CURL::libcurl``
  The curl library

Result Variables
^^^^^^^^^^^^^^^^

This will define the following variables:

``CURL_FOUND``
  True if the system has the curl library.
``CURL_VERSION``
  The version of the curl library which was found.

#]=======================================================================]

find_path(CURL_INCLUDE_DIR
  NAMES curl/curl.h
  PATHS /usr/include /usr/local/include
  NO_CACHE
)
find_library(CURL_LIBRARY
NAMES curl
PATHS /lib64
  NO_CACHE
)

message(STATUS "CURL_INCLUDE_DIR: ${CURL_INCLUDE_DIR}")

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(CURL
  FOUND_VAR CURL_FOUND
  REQUIRED_VARS CURL_LIBRARY CURL_INCLUDE_DIR
  VERSION_VAR CURL_VERSION
)

if(CURL_FOUND AND NOT TARGET CURL::libcurl)
  add_library(CURL::libcurl UNKNOWN IMPORTED)
  set_target_properties(CURL::libcurl PROPERTIES
    IMPORTED_LOCATION "${CURL_LIBRARY}"
    INTERFACE_INCLUDE_DIRECTORIES "${CURL_INCLUDE_DIR}"
  )
endif()