#[=======================================================================[.rst:
Finddocopt
-------------

Finds the docopt library.

Imported Targets
^^^^^^^^^^^^^^^^

This module provides the following imported targets, if found:

``docopt::docopt``
  The docopt library

Result Variables
^^^^^^^^^^^^^^^^

This will define the following variables:

``docopt_FOUND``
  True if the system has the docopt library.
``docopt_VERSION``
  The version of the docopt library which was found.

#]=======================================================================]

find_path(docopt_INCLUDE_DIR
  NAMES docopt/docopt.h
  PATHS ${docopt_ROOT}/include
  PATH_SUFFIXES docopt
  NO_CACHE
)
find_library(docopt_LIBRARY
  NAMES docopt
  PATHS ${docopt_ROOT}/lib64
  NO_CACHE
)

find_package(PkgConfig)
if(PKG_CONFIG_FOUND)
  set(ENV{PKG_CONFIG_PATH} "${docopt_ROOT}/lib/pkgconfig:$ENV{PKG_CONFIG_PATH}")
  pkg_check_modules(PKG_DOCOPT docopt QUIET)
  if(PKG_DOCOPT_FOUND)
    set(docopt_VERSION "${PKG_DOCOPT_VERSION}")
  endif()
endif()

# If not found via pkg-config, derive from the docopt_ROOT path or any fallback
if(NOT docopt_VERSION)
  # Example approach: parse the tail of docopt_ROOT
  # e.g. /path/to/docopt/V1.2.3/x86_64 => docopt_VERSION = V1.2.3
  if(docopt_ROOT)
    string(REGEX REPLACE "^.*/([^/]+)/[^/]+$" "\\1" docopt_VERSION "${docopt_ROOT}")
  endif()
endif()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(docopt
  FOUND_VAR docopt_FOUND
  REQUIRED_VARS docopt_LIBRARY docopt_INCLUDE_DIR
  VERSION_VAR docopt_VERSION
)

if(docopt_FOUND AND NOT TARGET docopt::docopt)
  add_library(docopt::docopt UNKNOWN IMPORTED)
  set_target_properties(docopt::docopt PROPERTIES
    IMPORTED_LOCATION "${docopt_LIBRARY}"
    INTERFACE_INCLUDE_DIRECTORIES "${docopt_INCLUDE_DIR}"
  )
endif()